/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISDAdvancedPagingProvider.java,v 1.5 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.provider;

/**
 * An advanced paging provider is able to compute number of pages, and to display the number
 * of items it treats on each page and for total counts.<br>
 * An item can be a message, a node or anything meaningful from loader standpoint.<br>
 * Items are only here for information to the user.
 */
public interface ISDAdvancedPagingProvider extends ISDPagingProvider {
	
	/**
	 * @return number of items in a page
	 * @deprecated
	 */
	public int maxItemsByPageCount();

	/**
	 * @return the total number of items the loader is dealing with (on all pages)
	 * @deprecated
	 */
	public int itemsTotalCount();
	
	/**
	 * @return text to be shown when maxItemsByPageCount() or itemsTotalCount() return 0
	 * @deprecated
	 */
	public String noItemsText();
	/**
	 * @return text to be shown when maxItemsByPageCount() or itemsTotalCount() return 1
	 * @deprecated
	 */
	public String oneItemText();
	/**
	 * @return text to be shown when maxItemsByPageCount() or itemsTotalCount() return 2 or more
	 * @deprecated
	 */
	public String itemsText();
	
	/**
	 * @return the current page the loader is dealing with
	 * <b>Note<b> that first page has the 0 index (indexes are from 0 to pagesCount()-1).
	 */
	public int currentPage();
	
	/**
	 * @return number of pages the loader is dealing with
	 */
	public int pagesCount();
	
	/**
	 * Updates the number of items in a page and instructs a load of &lt;pageNumber_&gt;<i>th</i> page.<br>
	 * <b>Note<b> that first page has the 0 index (indexes are from 0 to pagesCount()-1).
	 * @param maxItemsByPage_ index of the page to load
	 * @param pageNumber_ index of the page to load
	 * @deprecated
	 */
	public void pageSettingsChanged(int maxItemsByPage_, int pageNumber_);

	/**
	 * Instructs a load of the &lt;pageNumber_&gt;<i>th</i> page.<br>
	 * <b>Note<b> that first page has the index 0 (indexes are from 0 to pagesCount()-1).
	 * @param pageNumber_ index of the page to load
	 */
	public void pageNumberChanged(int pageNumber_);
	
}
