/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISDFilterProvider.java,v 1.5 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.provider;

import java.util.List;

/**
 * Sequence Diagram loaders which implement this class provide the
 * actions filtering the sequence diagram.<br>
 * This interface also allow the implementor to set wich graph nodes are supporting filtering
 * (thanks to ISDGraphNodeSupporter extension).<br>
 * 
 * Action provider are associated to a Sequence Diagram SDWidget calling 
 * <code>SDViewer.setSDFilterProvider</code><br>
 * 
 * Filters to be applied to be managed by the loader in an ArrayList of FilterCriteria.<br>
 */
public interface ISDFilterProvider extends ISDGraphNodeSupporter {

	/**
	 * Called when the Filter dialog box OK button is pressed
	 * @param toApply user selection made in the dialog box
	 * @return true if the filter applied
	 */
	public boolean filter(List filters);
	
}
