/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Criteria.java,v 1.8 2005/04/21 10:09:21 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDGraphNodeSupporter;
import org.eclipse.jface.dialogs.DialogSettings;

/**
 * This class discribe the Find or Filter criteria selected by the user 
 * in the Find or Filter dialog box
 * @author sveyrier
 */
public class Criteria {
	

	protected boolean lifeLineSelected = false;
	protected boolean syncMessageSelected = false;
	protected boolean syncMessageReturnSelected = false;
	protected boolean asyncMessageSelected = false;
	protected boolean asyncMessageReturnSelected = false;
	protected boolean caseSenstiveSelected = false;
	protected boolean stopSelected;
	protected String expression = null;
	
	/**
	 * Returns true if the AsyncMessageReturn is seclected, false otherwise
	 * @return true if the AsyncMessageReturn is seclected, false otherwise
	 */
	public boolean isAsyncMessageReturnSelected() {
		return asyncMessageReturnSelected;
	}

	/**
	 * Returns true if the AsyncMessage is seclected, false otherwise
	 * @return true if the AsyncMessage is seclected, false otherwise
	 */
	public boolean isAsyncMessageSelected() {
		return asyncMessageSelected;
	}
	
	/**
	 * Returns the text enter by the user
	 * @return the text
	 */
	public String getExpression() {
		return expression;
	}

	/**
	 * Returns true if the LifeLine is seclected, false otherwise
	 * @return true if the LifeLine is seclected, false otherwise
	 */
	public boolean isLifeLineSelected() {
		return lifeLineSelected;
	}

	/**
	 * Returns true if the Stop is seclected, false otherwise
	 * @return true if the Stop is seclected, false otherwise
	 */
	public boolean isStopSelected() {
		return stopSelected;
	}

	/**
	 * Returns true if the SyncMessageReturn is seclected, false otherwise
	 * @return true if the SyncMessageReturn is seclected, false otherwise
	 */
	public boolean isSyncMessageReturnSelected() {
		return syncMessageReturnSelected;
	}

	/**
	 * Returns true if the SyncMessage is seclected, false otherwise
	 * @return true if the SyncMessage is seclected, false otherwise
	 */
	public boolean isSyncMessageSelected() {
		return syncMessageSelected;
	}

	/**
	 * Set AsyncMessageReturn selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setAsyncMessageReturnSelected(boolean b) {
		asyncMessageReturnSelected = b;
	}

	/**
	 * Set AsyncMessage selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setAsyncMessageSelected(boolean b) {
		asyncMessageSelected = b;
	}

	/**
	 * Set the text enter by the user
	 * @param string the text
	 */
	public void setExpression(String string) {
		expression = string;
	}

	/**
	 * Set Stop selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setLifeLineSelected(boolean b) {
		lifeLineSelected = b;
	}

	/**
	 * Set Stop selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setStopSelected(boolean b) {
		stopSelected = b;
	}

	/**
	 * Set SyncMessageReturn selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setSyncMessageReturnSelected(boolean b) {
		syncMessageReturnSelected = b;
	}
	/**
	 * Set SyncMessage selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setSyncMessageSelected(boolean b) {
		syncMessageSelected = b;
	}

	/**
	 * Returns true if the case sentive is seclected, false otherwise
	 * @return true if the case sentive is seclected, false otherwise
	 */
	public boolean isCaseSenstiveSelected() {
		return caseSenstiveSelected;
	}

	/**
	 * Set case sentive selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setCaseSenstiveSelected(boolean b) {
		caseSenstiveSelected = b;
	}
	
	/**
	 * @param to
	 * @return
	 */
	public boolean equals(Criteria to) {
		return getExpression().equals(to.getExpression()) &&
			   isCaseSenstiveSelected() == to.isCaseSenstiveSelected() &&
			   isAsyncMessageReturnSelected() == to.isAsyncMessageReturnSelected() &&
			   isAsyncMessageSelected() == to.isAsyncMessageSelected() &&
			   isLifeLineSelected() == to.isLifeLineSelected() &&
			   isStopSelected() == to.isStopSelected() &&
			   isSyncMessageReturnSelected() == to.isSyncMessageReturnSelected() &&
			   isSyncMessageSelected() == to.isSyncMessageSelected();
	}
	
	/**
	 * @param settings
	 */
	public void save(DialogSettings settings) {
		settings.put("expression",getExpression()); //$NON-NLS-1$
		settings.put("isCaseSenstiveSelected",isCaseSenstiveSelected()); //$NON-NLS-1$
		settings.put("isAsyncMessageReturnSelected",isAsyncMessageReturnSelected()); //$NON-NLS-1$
		settings.put("isAsyncMessageSelected",isAsyncMessageSelected()); //$NON-NLS-1$
		settings.put("isLifeLineSelected",isLifeLineSelected()); //$NON-NLS-1$
		settings.put("isStopSelected",isStopSelected()); //$NON-NLS-1$
		settings.put("isSyncMessageReturnSelected",isSyncMessageReturnSelected()); //$NON-NLS-1$
		settings.put("isSyncMessageSelected",isSyncMessageSelected()); //$NON-NLS-1$
	}

	/**
	 * @param settings
	 */
	public void load(DialogSettings settings) {
		setExpression(settings.get("expression")); //$NON-NLS-1$
		setCaseSenstiveSelected(settings.getBoolean("isCaseSenstiveSelected")); //$NON-NLS-1$
		setAsyncMessageReturnSelected(settings.getBoolean("isAsyncMessageReturnSelected")); //$NON-NLS-1$
		setAsyncMessageSelected(settings.getBoolean("isAsyncMessageSelected")); //$NON-NLS-1$
		setLifeLineSelected(settings.getBoolean("isLifeLineSelected")); //$NON-NLS-1$
		setStopSelected(settings.getBoolean("isStopSelected")); //$NON-NLS-1$
		setSyncMessageReturnSelected(settings.getBoolean("isSyncMessageReturnSelected")); //$NON-NLS-1$
		setSyncMessageSelected(settings.getBoolean("isSyncMessageSelected")); //$NON-NLS-1$
	}
	
	public String getGraphNodeSummary(ISDFilterProvider provider) {
		ArrayList list = new ArrayList();
		
		if (provider != null && provider instanceof ISDGraphNodeSupporter) {
			if (isLifeLineSelected()) {
				list.add(provider.getNodeName(ISDGraphNodeSupporter.LIFELINE));
			}
			if (isSyncMessageSelected()) {
				list.add(provider.getNodeName(ISDGraphNodeSupporter.SYNCMESSAGE));
			}
			if (isSyncMessageReturnSelected()) {
				list.add(provider.getNodeName(ISDGraphNodeSupporter.SYNCMESSAGERETURN));
			}
			if (isAsyncMessageSelected()) {
				list.add(provider.getNodeName(ISDGraphNodeSupporter.ASYNCMESSAGE));
			}
			if (isAsyncMessageReturnSelected()) {
				list.add(provider.getNodeName(ISDGraphNodeSupporter.ASYNCMESSAGERETURN));
			}
			if (isStopSelected()) {
				list.add(provider.getNodeName(ISDGraphNodeSupporter.STOP));
			}
		} else {
			if (isLifeLineSelected()) {
				list.add(SDViewerPlugin.getResourceString("FIND_FILTER_LIFELINE")); //$NON-NLS-1$
			}
			if (isSyncMessageSelected()) {
				list.add(SDViewerPlugin.getResourceString("FIND_FILTER_SYNC_MESS")); //$NON-NLS-1$
			}
			if (isSyncMessageReturnSelected()) {
				list.add(SDViewerPlugin.getResourceString("FIND_FILTER_SYNC_MESS_RET")); //$NON-NLS-1$
			}
			if (isAsyncMessageSelected()) {
				list.add(SDViewerPlugin.getResourceString("FIND_FILTER_ASYNC_MESS")); //$NON-NLS-1$
			}
			if (isAsyncMessageReturnSelected()) {
				list.add(SDViewerPlugin.getResourceString("FIND_FILTER_ASYNC_MESS_RET")); //$NON-NLS-1$
			}
			if (isStopSelected()) {
				list.add(SDViewerPlugin.getResourceString("FIND_FILTER_STOP")); //$NON-NLS-1$
			}
		}
		
		String ret = "", prefix = "["; //$NON-NLS-1$ //$NON-NLS-2$
		for (Iterator i = list.iterator(); i.hasNext(); ) {
			String s = (String)i.next();
			ret += prefix + s;
			prefix = " "+SDViewerPlugin.getResourceString("FIND_FILTER_OR")+" "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		ret += "]"; //$NON-NLS-1$
		return ret;
	}

}
