/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DiagramToolTip.java,v 1.4 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.view;


import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;



/**
 * This class is used to reproduce the same tooltip behavior on Windows and Linux
 * when the mouse move hover the sequence diagram
 * @author sveyrier
 */
public class DiagramToolTip implements PaintListener  {

	/**
	 * The parent control where the tooltip must be drawn
	 */
	protected Control parent = null;
	/**
	 * The tooltip shell
	 */
	protected Shell toolTipShell = null;
	/**
	 * The tooltip text
	 */
	protected String text = null;

	/**
	 * Create a new tooltip for the given parent control
	 * @param _parent the parent control
	 */
	public DiagramToolTip(Control _parent)
	{
		parent = _parent;
		toolTipShell = new Shell(parent.getShell(),SWT.ON_TOP|SWT.NO_FOCUS);
		toolTipShell.setLayout(new RowLayout());
		toolTipShell.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_INFO_BACKGROUND));
		toolTipShell.addPaintListener(this);
		toolTipShell.setSize(10,10);
	}
	
	/**
	 * Display the tooltip using the given text
	 * The tooltip will stay on screen until it is told otherwise
	 * @param value the text to display
	 */
	public void showToolTip(String value)
	{
		if ((value==null)||(value.equalsIgnoreCase("")))//$NON-NLS-1$
		{
			toolTipShell.setVisible(false);
			return;
		}
		text=value;
		int w = toolTipShell.getBounds().width;
		int h = toolTipShell.getBounds().height;
		Point hr = Display.getDefault().getCursorLocation();
		int cursorH=32;
		for (int i=0;i<Display.getDefault().getCursorSizes().length;i++)
		{
			if (Display.getDefault().getCursorSizes()[i].y<cursorH)
				cursorH=Display.getDefault().getCursorSizes()[i].y;
		}	
		if (hr.x+w>Display.getDefault().getBounds().width)
		{
			int tempX=(hr.x+w)-Display.getDefault().getBounds().width;
			if (tempX>Display.getDefault().getBounds().width)
				hr.x = 0;
			hr.x=hr.x-tempX;
		}
		toolTipShell.setLocation(hr.x,hr.y+cursorH);
		toolTipShell.setVisible(true);
	}
	
	
	/**
	 * Hide the tooltip
	 */
	public void hideToolTip()
	{
		toolTipShell.setVisible(false);
	}
	
	/**
	 * Draw the tooltip text on the control widget when a paint event is received
	 */
	public void paintControl(PaintEvent event)
	{
		Point size = event.gc.textExtent(text);		
		event.gc.drawText(text,2,0,true);	
		toolTipShell.setSize(size.x+6,size.y+2);
	}
}
