/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogThreadInteractions.java,v 1.17 2005/04/07 20:10:58 slavescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc.internal.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;


/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogThreadInteractions extends LogInteractions {
	
	private List threadIDs = new UniqueEList();
	static{		
		traceCategories = new LifelineCategories[1];
		traceCategories[CATEGORY_LOGS] = new LifelineCategories();
		traceCategories[CATEGORY_LOGS].setName(""); 
		image = SDLogcPluginImages.getImage(SDLogcPluginImages.IMG_THREAD);
		traceCategories[CATEGORY_LOGS].setImage(image); 
	}
		
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.loader.LogInteractions#loadEvents(java.util.List)
	 */
	protected void loadEventsXMI() {

		if(!isDisplayingOnlyCorrelations()){
			loadThreadIdsFromAgentList(true);
		}else{
			loadThreadIdsFromAgentList(false);
			loadEventsFromCorrelationsXMI();
		}
	}
	
	private void loadThreadIdsFromAgentList(boolean addEvents) {
		for (Iterator iter = agentsList.iterator(); iter.hasNext();) {
			TRCAgentProxy trcAgentProxy = (TRCAgentProxy) iter.next();
			if (trcAgentProxy != null && !trcAgentProxy.eIsProxy())
			{				
				loadThreadIdsFromAgent(trcAgentProxy);
				if (addEvents) addEvents(trcAgentProxy);
			}
		}
		if (eventsList != null && eventsList.size() > 0)
			Collections.sort(eventsList, getComparator());
	}
	
	
	
	private void loadThreadIdsFromAgent(TRCAgentProxy agentProxy){
		
		List events = agentProxy.getAgent().getDefaultEvents();
		CBECommonBaseEvent artifact = null;
		String threadID = null;
		
		for (Iterator iter = events.iterator(); iter.hasNext();) {
			artifact = (CBECommonBaseEvent)iter.next();
			
			threadID = artifact.getSourceComponentId().getThreadId();
			if (threadID==null)
				threadID="-1";
			threadIDs.add(agentProxy.getName()+" - "+"TID:" + threadID);
		}				
	}
		
	protected void generateLifelines(){
		String id = null;
		for (Iterator iter = getLifelineArtifactsList().iterator(); iter.hasNext();) {
			id = (String)iter.next();
			TraceLifeline lifeLine = new TraceLifeline();
			lifeLine.setName(id);
			lifeLine.setCategory(CATEGORY_LOGS);				
			frame.addLifeLine(lifeLine);
			lifelinesMap.put(id, lifeLine);
		}

	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.loader.LogInteractions#getLifelinesMapKey(org.eclipse.hyades.models.cbe.CBECommonBaseEvent)
	 */
	protected Object getLifelinesMapKey(CBECommonBaseEvent element) {

		String threadID = element.getSourceComponentId().getThreadId();
		if(threadID==null){
			threadID = "-1";
		}
		return element.getAgent().getAgentProxy().getName()+" - "+"TID:" + threadID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getTitleString() {
		StringBuffer title = new StringBuffer();
		title.append(SDLogcPlugin.getString("STR_VIEW_TITLE"));
		title.append(": ");
		title.append(SDLogcPlugin.getString("STR_MENU_LOT"));
		title.append(" ");
		//String title = SDLogcPlugin.getString("STR_VIEW_TITLE") +": "+ SDLogcPlugin.getString("STR_MENU_LOT");
		if(correlationContainerProxy!=null){
			title.append("<");
			title.append(correlationContainerProxy.getCorrelationEngine().getName());
			title.append("> ");
			//title = title + " <"+correlationContainerProxy.getCorrelationEngine().getName()+"> ";
		}else{
			title.append("   ");
		}
		title.append("(");
		title.append(getFrameName());
		title.append(")");
		return title.toString();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.loader.LogInteractions#getLifelineArtifactsList()
	 */
	protected List getLifelineArtifactsList() {
		
		return threadIDs;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.loader.LogInteractions#clearDiagramCaches()
	 */
	protected void clearDiagramCaches() {		
		threadIDs.clear();
		super.clearDiagramCaches();		
	}
	
	protected String getFrameTitle(){
		return SDLogcPlugin.getString("STR_MENU_LOT");//+ ":      " + getFrameName();
	}
	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.loader.LogInteractions#loadEventsSQL()
	 */
	protected void loadEventsSQL() {
		loadThreadIDsSQL();
		super.loadEventsSQL();
		
	}
	private static List getANDArguments(SimpleSearchQuery query) {
		return ((LogicalExpression) query.getWhereExpression()).getArguments();
	}	
	private void loadThreadIDsSQL(){
		List aList = new ArrayList();
		for(int i=0;i<agentsList.size();i++){
			aList.add(((TRCAgentProxy)agentsList.get(i)).getAgent());
		}
		
		SimpleSearchQuery threadsQuery;
		
		if (FilterUIUtil.ENABLE_NEW_FILTERING && FilterUIUtil.ENABLE_NEW_FILTERING_FOR_SQL)
		{
			threadsQuery = getQueryForSQL(agentsList,false);
			threadsQuery.getOutputElements().clear();
			SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
			operand.setType(HierarchyPackage.eINSTANCE.getTRCAgent());
			threadsQuery.getOutputElements().add(operand);
			operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
			operand.setFeature(CBEPackage.eINSTANCE.getCBEComponentIdentification_ThreadId());
			threadsQuery.getOutputElements().add(operand);
		}
		
		else
			threadsQuery = (SimpleSearchQuery)LogQueryBuilder.createQuery(agentsList, getFilterCriteria(), CBEPackage.eINSTANCE.getCBEComponentIdentification_ThreadId());

		threadsQuery.getOrderByExpresions().clear();
		BinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
		
		SimpleOperand leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
		leftOperand.setType(HierarchyPackage.eINSTANCE.getTRCAgent());
		binaryExpression.setLeftOperand(leftOperand);
		binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
		LogQueryBuilder.setRightOperandValue(binaryExpression,HierarchyPackage.eINSTANCE.getAbstractDefaultEvent_Agent());

		getANDArguments(threadsQuery).add(binaryExpression);

		binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
		leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
		leftOperand.setType(HierarchyPackage.eINSTANCE.getAbstractDefaultEvent());
		binaryExpression.setLeftOperand(leftOperand);
		binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
		LogQueryBuilder.setRightOperandValue(binaryExpression,CBEPackage.eINSTANCE.getCBECommonBaseEvent());

		getANDArguments(threadsQuery).add(binaryExpression);

		binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
		leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
		leftOperand.setType(CBEPackage.eINSTANCE.getCBEComponentIdentification());
		binaryExpression.setLeftOperand(leftOperand);
		binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
		LogQueryBuilder.setRightOperandValue(binaryExpression,CBEPackage.eINSTANCE.getCBECommonBaseEvent_SourceComponentId());

		getANDArguments(threadsQuery).add(binaryExpression);
		
		threadsQuery.setDistinct(true);
		QueryResult queryResult = LogQueryBuilder.executeQuery(threadsQuery, HierarchyResourceSetImpl.getInstance());
		if(queryResult!=null)
		{
			ResultEntry resultEntry =(ResultEntry)queryResult.getResultEntries().get(0);  
			List agents = (List)resultEntry.getValue();
			resultEntry =(ResultEntry)queryResult.getResultEntries().get(1);
			List threads =  (List)resultEntry.getValue(); 
			if(agents!=null && agents.size()>0){
				int s = agents.size();
				String threadId = null;
				TRCAgent agent = null;
				for(int i=0;i<s;i++){
					agent = (TRCAgent)agents.get(i);
					threadId = (String)threads.get(i); 
					if(agent!=null ){
						if (threadId==null)
							threadId="-1";					
						threadIDs.add(agent.getAgentProxy().getName()+" - "+"TID:" + threadId);
					}
				}
			}

		}
		
	}
}
