/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecorderWizard.java,v 1.6 2005/02/16 22:20:19 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.recorder.ui.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/**
 * Abstract Wizard which should be extended by wizards associated with Recorders.  This object automatically handles the recorders 
 * control view and handles save calls to each individual wizard page is owns.
 * @author Ernest Jessee
 */
public abstract class RecorderWizard
	extends HyadesNewWizard
	implements INewWizard, IRunnableWithProgress
{

	protected IProgressMonitor monitor = null;
	/**
	 * this method, when implemented should start the target recorder
	 */
	public void run(IProgressMonitor monitor)throws InvocationTargetException, InterruptedException
	{
		this.monitor = monitor;
		run();
	}
	
	public abstract void run();
	
	
	/**
	 * method which passes through the wizardpage collection and calls save on each
	 */
	public void saveSettings()
	{
		
		IWizardPage[] wizPages = getPages();
		
		for(int i=0; i<wizPages.length;i++)
		{
			
			ITestGenWizardPage wizPage = (ITestGenWizardPage)wizPages[i];
			wizPage.saveSettings();
		}
		
	}


	/**
	 * handles the finish button by resetting the control view and initiating a run call on the extender class
	 */
	public boolean performFinish()
	{		

		saveSettings();
		if (!verifyRecorderData())
			return false;
		RecorderControlView.getInstance().reset();
		
		
		IRunnableWithProgress op = new WorkspaceModifyDelegatingOperation(this);
		try 
		{
			getContainer().run(false, true, op);
			return true;
		}
		catch (InvocationTargetException e) 
		{
			e.printStackTrace();
			return false;
		} catch (InterruptedException e) {
			e.printStackTrace();
			return false;
		}
	}
	

	

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile arg0) throws Exception
	{
		return true;
	}
	/**
	 * extenders may use this to ensure all data collected is OK, popup a verifaction dialog.
	 * If false is returned, performFinish will return false & run() is not executed.
	 * By default this method simply returns true.     
	 * @return
	 */
	protected boolean verifyRecorderData()
	{
		return true;
	}

}
