/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: JavaTaskRemoteHyadesComponentSkeleton.java,v 1.4 2005/02/16 22:20:26 qiyanli Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/
package org.eclipse.hyades.execution.remote;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IDataChannel;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.core.TimeoutException;

/**
 * At present, this class does not provide much functionality. Most of the
 * monitoring operations are implemented entirely on the local side. Those
 * operations that will involve both the local and remote layers do not, at
 * present, do anything meaningful.
 */
public class JavaTaskRemoteHyadesComponentSkeleton extends ExecutionComponentSkeleton implements IRemoteHyadesComponent {
	
	private boolean isLocked;

	public JavaTaskRemoteHyadesComponentSkeleton() {
		super();
	}
	
	/**
	 * This method is implemented in the stub layer.
	 * 
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#isActive()
	 */
	public boolean isActive() {
		throw new UnsupportedOperationException("This method is implemented in the stub for this component");
	}

	/**
	 * This method is implemented in the stub layer.
	 * 
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#isMonitored()
	 */
	public boolean isMonitored() {
		throw new UnsupportedOperationException("This method is implemented in the stub for this component");
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#isLocked()
	 */
	public boolean isLocked() {
		return isLocked;
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#lock(long)
	 */
	public void lock(long timeout) throws TimeoutException {
		synchronized(delegate) {
			try {
				isLocked=true;
				delegate.wait(timeout);
			}
			catch(InterruptedException e) {
				isLocked=false;
				throw new TimeoutException();
			}
			isLocked=false;
		}
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#unlock()
	 */
	public void unlock() {
		synchronized(delegate) {
			delegate.notifyAll();	
		}
	}

	/**
	 * This method is implemented in the stub layer.
	 * 
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#startMonitoring(org.eclipse.hyades.execution.core.IDataChannel)
	 */
	public void startMonitoring(IDataChannel processor)
		throws ExecutionComponentStateException {
		throw new UnsupportedOperationException("This method is implemented in the stub for this component");
	}

	/**
	 * This method is implemented in the stub layer.
	 * 
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#stopMonitoring()
	 */
	public void stopMonitoring() throws ExecutionComponentStateException {
		throw new UnsupportedOperationException("This method is implemented in the stub for this component");
	}
	
	/**
	 * This method is implemented in the stub layer.
	 * 
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#startMonitoring(org.eclipse.hyades.execution.core.IDataProcessor)
	 */
	public void startMonitoring(IDataProcessor arg0) throws ExecutionComponentStateException {
		throw new UnsupportedOperationException("This method is implemented in the stub for this component");
	}

}
