/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLwaitEventLoader.java,v 1.3 2005/02/16 22:21:06 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFWaitEvent;

/**
 * This is the loader for the <code>waitEvent</code> XML tag for the 
 * TPFWaitEvent. This loader is different from the other loaders in that
 * it is an extension to the <code>XMLtimedEventLoader</code> which 
 * extends the <code>XMLexecutionEventLoader</code>.
 * 
 * @author amathur
 */
public class XMLwaitEventLoader extends XMLtimedEventLoader {
	
	// No Attributes in this class. Its really a tag class for the TPFTimedEvent
	
	/**
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		// Nothing to do since no attributes
		super.initialize(context, name);
	}

	/**
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		// Nothing to do since no attributes
		super.addAttribute(name, value);
	}
	/**
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		// Event could have been created by the extended class XMLwaitEventLoader
		TPFWaitEvent event = Common_TestprofileFactory.eINSTANCE.createTPFWaitEvent();
		
		// No attributes to set here
		
		// populate the event with the base event attributes
		this.event = event;
		super.addYourselfInContext();
		// Do not call super.addYourselfInContainer() since the base class (XMLtimedEventLoader)
		// is calling it.
	}
}
