/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CFGClass.java,v 1.10 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration;

import org.eclipse.emf.common.util.EList;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>CFG Class</b></em>'.
 * @extends IDeployableComponent
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A CFGDeployable is an element that describes behavioral (operation/behavior), and structural features (Instance) and may be instantiable. Mapped to a programming language like java, it comes in several specific forms, including class, interface, etc.
 * 
 * It owns CFGInstances which define its internal structure (class attributes).
 * 
 * A CFGDeployable has a behaviorResource and behaviorLocation which describe where its behavior is stored: Resource URL and Location within the resource .
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGClass#getOperations <em>Operations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGClass#getInstances <em>Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGClass#getInstantiations <em>Instantiations</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGClass()
 * @model abstract="true"
 * @generated
 */
public interface CFGClass extends CMNNamedElement, IDeployableComponent{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Operations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGOperation}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGOperation#getOwningClass <em>Owning Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operations</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGClass_Operations()
	 * @see org.eclipse.hyades.models.common.configuration.CFGOperation#getOwningClass
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGOperation" opposite="owningClass" containment="true"
	 * @generated
	 */
	EList getOperations();

	/**
	 * Returns the value of the '<em><b>Instances</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGInstance}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getClassOwner <em>Class Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Instances</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Instances</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGClass_Instances()
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getClassOwner
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGInstance" opposite="classOwner" containment="true"
	 * @generated
	 */
	EList getInstances();

	/**
	 * Returns the value of the '<em><b>Instantiations</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGInstance}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getClassType <em>Class Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Instantiations</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Instantiations</em>' reference list.
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGClass_Instantiations()
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getClassType
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGInstance" opposite="classType"
	 * @generated
	 */
	EList getInstantiations();

} // CFGClass
