/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CFGConfigurableObjectImpl.java,v 1.10 2005/03/28 21:51:31 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;

import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Configurable Object</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGConfigurableObjectImpl#getPropertyGroups <em>Property Groups</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CFGConfigurableObjectImpl extends CMNNamedElementImpl implements CFGConfigurableObject {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached value of the '{@link #getPropertyGroups() <em>Property Groups</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPropertyGroups()
	 * @generated
	 * @ordered
	 */
	protected EList propertyGroups = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CFGConfigurableObjectImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_ConfigurationPackage.eINSTANCE.getCFGConfigurableObject();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getPropertyGroups() {
		if (propertyGroups == null) {
			propertyGroups = new EObjectContainmentWithInverseEList(CFGPropertyGroup.class, this, Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT);
		}
		return propertyGroups;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS:
					return ((InternalEList)getPropertyGroups()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS:
					return ((InternalEList)getPropertyGroups()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__ID:
				return getId();
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__DESCRIPTION:
				return getDescription();
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__NAME:
				return getName();
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS:
				return getPropertyGroups();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__ID:
				setId((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__NAME:
				setName((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS:
				getPropertyGroups().clear();
				getPropertyGroups().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS:
				getPropertyGroups().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS:
				return propertyGroups != null && !propertyGroups.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //CFGConfigurableObjectImpl
