/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPLCellImpl.java,v 1.33 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEvaluatorExt;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.util.DatapoolUtil;
import org.eclipse.hyades.models.common.util.XMLParserUtil;
import org.w3c.dom.Document;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>DPL Cell</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLCellImpl#getValue <em>Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLCellImpl#getVariable <em>Variable</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DPLCellImpl extends EObjectImpl 
                         implements DPLCell 
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = ""; //$NON-NLS-1$

	/**
	 * The default value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected static final String VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected String value = VALUE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getVariable() <em>Variable</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVariable()
	 * @generated
	 * @ordered
	 */
	protected DPLVariable variable = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DPLCellImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_DatapoolPackage.eINSTANCE.getDPLCell();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValue(String newValue) {
		String oldValue = value;
		value = newValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_CELL__VALUE, oldValue, value));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLVariable getVariable() {
		if (variable != null && variable.eIsProxy()) {
			DPLVariable oldVariable = variable;
			variable = (DPLVariable)eResolveProxy((InternalEObject)variable);
			if (variable != oldVariable) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_DatapoolPackage.DPL_CELL__VARIABLE, oldVariable, variable));
			}
		}
		return variable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLVariable basicGetVariable() {
		return variable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVariable(DPLVariable newVariable) {
		DPLVariable oldVariable = variable;
		variable = newVariable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_CELL__VARIABLE, oldVariable, variable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_CELL__VALUE:
				return getValue();
			case Common_DatapoolPackage.DPL_CELL__VARIABLE:
				if (resolve) return getVariable();
				return basicGetVariable();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_CELL__VALUE:
				setValue((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_CELL__VARIABLE:
				setVariable((DPLVariable)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_CELL__VALUE:
				setValue(VALUE_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_CELL__VARIABLE:
				setVariable((DPLVariable)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_CELL__VALUE:
				return VALUE_EDEFAULT == null ? value != null : !VALUE_EDEFAULT.equals(value);
			case Common_DatapoolPackage.DPL_CELL__VARIABLE:
				return variable != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (value: ");
		result.append(value);
		result.append(')');
		return result.toString();
	}

	//beginning of non-generated classes

	//org.eclipse.hyades.edit.datapool.IDatapoolCell methods

	/**
	 * Defines the {@link IDatapoolVariable variable} that is used to reference
	 * this cell within a {@link IDatapoolRecord record}.
	 * 
	 * @param	variable	The {@link IDatapoolVariable variable} will be used to reference
	 *			this cell within a {@link IDatapoolRecord record}.
	 */
	public void setVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable)
	{
		this.setVariable((DPLVariable)variable);		
	}
		
	/**
	 * The unprocessed string representation of the cell is returned.
	 * 
	 * @return	The unprocessed string representation of the cell.
	 * 
	 * @see #setRawValue()
	 */
	public String getPersistedRepresentation(){
		if(this.getValue() != null)
			return this.getValue();	
		else
			return wrapAsLiteral(new String());
	}
	
	/**
	 * Access to the {@link IDatapoolVariable variable} that is used to reference
	 * this cell within a {@link IDatapoolRecord record}.
	 * 
	 * @return	The {@link IDatapoolVariable variable} that is used to reference
	 *			this cell within a {@link IDatapoolRecord record}.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable getCellVariable()
	{
		return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable)getVariable();
	}

	/**
	 * Access to the {@link IDatapoolRecord record} that is the parent of this
	 * cell.
	 * 
	 * @return	The {@link IDatapoolRecord record} that is the parent of this
	 *			cell.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord getCellRecord()
	{
		return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord)this.eContainer();
	}

	private static final String XML_AMPERSAND = "&amp;"; //$NON-NLS-1$
	private static final String AMPERSAND = "&"; //$NON-NLS-1$
	
	/**
	 * The value associated with the cell is returned.
	 * 
	 * @return	The value associated with the cell is returned.
	 */
	public Object getCellValue()
	{	
		
		//based on the tag from cell's value, invoke evaluator extension to evaluate tagged data
		//ex: <Literal>password</Literal>
		//    extension for Literal tag will evaluate password "literally"
		
		if (this.getValue() == null)
			return null;
		
		String internalValue;

		internalValue = this.getValue();		
		internalValue = internalValue.replaceAll(AMPERSAND, XML_AMPERSAND);
		
		String tag = null, val = null;
		
        //get the tag and value from the XML fragment
		try {		
			Document doc = XMLParserUtil.parse(internalValue);		
			tag = doc.getFirstChild().getNodeName();
			DPLLogImpl.log("Tag: " + tag); //$NON-NLS-1$
			val = doc.getFirstChild().getFirstChild().getNodeValue();
			DPLLogImpl.log("Val: " + val); //$NON-NLS-1$
	    }
	    catch (Throwable t) {
	    }
		
	    //try to find extension for evaluating tag
	    try 
		{
	    	IDatapoolEvaluatorExt evaluator = DatapoolUtil.findDatapoolEvaluator(tag);
	    	if(evaluator != null)
	    		return evaluator.evaluate(val);
	    	
	    	if (tag != null && tag.equals("Literal")) //$NON-NLS-1$
			{
				//no extension point found - unwrap by hand
				String wrappedValue = this.getValue();
				String value = unwrapLiteral(wrappedValue);
				return value;
			}
		}
	    catch (Exception e) {
			DPLLogImpl.log(e.getMessage());
		}
		
	    return this.getValue();
	}  
	
	/**
	 * A shortcut for the <code>String</code> value associated with the cell is returned.
	 * If the value in the cell is not a <code>String</code> value then it is
	 * converted to a <code>String</code> before being returned.
	 * 
	 * @return	The <code>String</code> value associated with the cell.
	 */
	public String getStringValue()
	{
		Object cellValue = this.getCellValue();
		if(cellValue != null)
			return cellValue.toString();
		else
			return new String();
	}
	
	/**
	 * A shortcut for the <code>long</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>long</code> value then an attempt
	 * is made to convert the value to a <code>long</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>long</code> value associated with the cell.
	 */
	public long getLongValue()
	{
		return Long.parseLong((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>int</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>int</code> value then an attempt
	 * is made to convert the value to a <code>int</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>int</code> value associated with the cell.
	 */
	public int getIntValue()
	{
		return Integer.parseInt((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>short</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>short</code> value then an attempt
	 * is made to convert the value to a <code>short</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>short</code> value associated with the cell.
	 */
	public short getShortValue()
	{
		return Short.parseShort((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>byte</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>byte</code> value then an attempt
	 * is made to convert the value to a <code>byte</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>byte</code> value associated with the cell.
	 */
	public byte getByteValue()
	{
		return Byte.parseByte((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>double</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>double</code> value then an attempt
	 * is made to convert the value to a <code>double</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>double</code> value associated with the cell.
	 */
	public double getDoubleValue()
	{
		return Double.parseDouble((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>float</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>float</code> value then an attempt
	 * is made to convert the value to a <code>float</code>.  If the value can not
	 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
	 * 
	 * @return	The <code>float</code> value associated with the cell.
	 */
	public float getFloatValue()
	{
		return Float.parseFloat((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>boolean</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>boolean</code> value then an attempt
	 * is made to convert the value to a <code>boolean</code>.  If the value can not
	 * be converted an appropriate exception will be thrown.
	 * 
	 * @return	The <code>boolean</code> value associated with the cell.
	 */
	public boolean getBooleanValue()
	{
		return Boolean.getBoolean ((String)this.getCellValue());
	}
	
	/**
	 * A shortcut for the <code>char</code> value associated with  the cell is returned.
	 * If the value in the cell is not a <code>char</code> value then an attempt
	 * is made to convert the value to a <code>char</code>.  If more then one 
	 * character is represented in the value only the first character will be
	 * returned.
	 * 
	 * @return	The <code>char</code> value associated with the cell.
	 */
	public char getCharValue()
	{
		return ((String)this.getCellValue()).charAt(0);
	}

	/**
	 * Replace the unprocessed persisted string representation.
	 * 
	 * @param	value		The value to be associated with this cell.
	 * 
	 * @see #getRawValue()
	 */
	public void setPersistedRepresentation(String value) 
	{
		this.setValue(value);			
	}
	
	/**
	 * Replace the value associated with the cell.
	 * 
	 * @param	value		The value to be associated with this cell.
	 * 
	 * @see #getCellValue()
	 */	
	public void setCellValue(Object value)
	{
		if(value == null)
		{
			this.setValue((String)value);
			return;
		}
		String tag = null, val = null;

		if(value.toString().indexOf("<") != -1) //$NON-NLS-1$
		{
	        //get the tag and value from the XML fragment
			try {	
				Document doc = XMLParserUtil.parse(value.toString());		
				tag = doc.getFirstChild().getNodeName();
				val = doc.getFirstChild().getFirstChild().getNodeValue();
		    }
		    catch (Throwable t) 
			{
		    }
		}
		
	    //try to find extension for evaluating tag
	    try 
		{
	    	if(tag != null && val != null)
	    	{
	    		IDatapoolEvaluatorExt evaluator = DatapoolUtil.findDatapoolEvaluator(tag);
	    		if(evaluator != null)
	    		{
	    			this.setValue(value.toString());
	    			return;
	    		}
	    	}
	    	
			//no extension point found which would match tag - throw exception
		    throw new DatapoolException(Messages.getString("DPLCellImpl.18") + tag); //$NON-NLS-1$
		}   
		catch (Throwable t) 
		{   
			String stringValue = value.toString();
			int index = stringValue.indexOf(START_LITERAL);
			if(index == -1)
			{			
				String wrappedValue = wrapAsLiteral(value.toString());
				this.setValue(wrappedValue);
				return;
			}				
			this.setValue(stringValue);
			return;
		}				
	}

	/**
	 * Clones the value associated with the cell.
	 *
	 * @return  A exact duplicate of the value.
	 */
	public Object getClonedCellValue()
	{
		return this.getCellValue();
	}

	
	private static final String START_LITERAL = "<Literal>"; //$NON-NLS-1$
	private static final String END_LITERAL = "</Literal>"; //$NON-NLS-1$

	/*
	 * Wraps the text in tags that indicate the text is a literal.  All cell 
	 * values in this release are literals.  Returns the wrapped string.
	 */	
	private String wrapAsLiteral(String text)
	{
		if(text != null)
			return START_LITERAL + text + END_LITERAL;
		else
			return START_LITERAL + END_LITERAL;
	}
	
	/*
	 * Takes a literal wrapped string and stips the literal tags.  Returns the
	 * unwrapped string.
	 */
	private String unwrapLiteral(String text)
	{
		text = text.trim();
		if(text.startsWith(START_LITERAL) && text.endsWith(END_LITERAL))
		{
			text = text.substring(START_LITERAL.length(), text.length());
			int endIndex = text.lastIndexOf(END_LITERAL);
			text = text.substring(0, endIndex);
			return text;	
		}
		else
			return new String();
		
	}



} //DPLCellImpl
