/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPLRecordImpl.java,v 1.15 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;
import java.util.ListIterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLRecord;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>DPL Record</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl#getDatapool <em>Datapool</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl#getCells <em>Cells</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DPLRecordImpl extends EObjectImpl 
                           implements DPLRecord
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = ""; //$NON-NLS-1$

	/**
	 * The cached value of the '{@link #getDatapool() <em>Datapool</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatapool()
	 * @generated
	 * @ordered
	 */
	protected DPLDatapoolSpec datapool = null;

	/**
	 * The cached value of the '{@link #getCells() <em>Cells</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCells()
	 * @generated
	 * @ordered
	 */
	protected EList cells = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DPLRecordImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_DatapoolPackage.eINSTANCE.getDPLRecord();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLDatapoolSpec getDatapool() {
		if (datapool != null && datapool.eIsProxy()) {
			DPLDatapoolSpec oldDatapool = datapool;
			datapool = (DPLDatapoolSpec)eResolveProxy((InternalEObject)datapool);
			if (datapool != oldDatapool) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_DatapoolPackage.DPL_RECORD__DATAPOOL, oldDatapool, datapool));
			}
		}
		return datapool;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLDatapoolSpec basicGetDatapool() {
		return datapool;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDatapool(DPLDatapoolSpec newDatapool) {
		DPLDatapoolSpec oldDatapool = datapool;
		datapool = newDatapool;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_RECORD__DATAPOOL, oldDatapool, datapool));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getCells() {
		if (cells == null) {
			cells = new EObjectContainmentEList(DPLCell.class, this, Common_DatapoolPackage.DPL_RECORD__CELLS);
		}
		return cells;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_DatapoolPackage.DPL_RECORD__CELLS:
					return ((InternalEList)getCells()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_RECORD__DATAPOOL:
				if (resolve) return getDatapool();
				return basicGetDatapool();
			case Common_DatapoolPackage.DPL_RECORD__CELLS:
				return getCells();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_RECORD__DATAPOOL:
				setDatapool((DPLDatapoolSpec)newValue);
				return;
			case Common_DatapoolPackage.DPL_RECORD__CELLS:
				getCells().clear();
				getCells().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_RECORD__DATAPOOL:
				setDatapool((DPLDatapoolSpec)null);
				return;
			case Common_DatapoolPackage.DPL_RECORD__CELLS:
				getCells().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_RECORD__DATAPOOL:
				return datapool != null;
			case Common_DatapoolPackage.DPL_RECORD__CELLS:
				return cells != null && !cells.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	//beginning of non-generated classes
	
	//org.eclipse.hyades.edit.datapool.IDatapoolRecord methods
	
	/**
	 * Replace a value at the specified zero based cell index.
	 * 
	 * @param	cell		The value to replace in the specified cell.
	 * @param	cellIndex	A zero based cell index.
	 * 
	 * @see #getCell(int)
	 */
	public void setCell(IDatapoolCell cell, int cellIndex)
	{
		this.insertCell((DPLCell)cell, cellIndex);
		
		
		//notify listener
		DPLEquivalenceClassImpl ec = (DPLEquivalenceClassImpl)(this.eContainer());
		DPLDatapoolImpl dp = (DPLDatapoolImpl)(ec.eContainer());
		IDatapoolListener[] listeners = ((DPLDatapoolImpl)dp).getDatapoolListeners();
		if (listeners != null)
		{
			int ecIndex = dp.getEquivalenceClassIndexById(ec.getId());
			int recordIndex = ec.getRecords().indexOf(this);

		    for(int i = 0; i < listeners.length; i++)
		        ((IDatapoolListener)listeners[i]).cellChanged((IDatapool)dp, ecIndex, recordIndex, cellIndex);
		}
		
	}
	
	//org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord methods
	
	/**
	 * The number of cells available in a record.
	 * 
	 * @return	The number of cells available.
	 */
	public int getCellCount()
	{
		return this.getCells().size();
	}
	
	/**
	 * The value for the cell in the current record and
	 * the specified variable is returned.  The variable is located by the
	 * specified zero based index.  A{@link DatapoolException} is thrown if 
	 * the name does not match a variable name in the record.
	 * 
	 * @param	cellIndex		The zero based cell index.
	 * @return	The value for the cell in the current record and
	 *			the specified variable.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolCell getCell(int cellIndex)
	{
		try { 
			return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolCell)
			   this.getCells().get(cellIndex);
		}
		catch (Throwable t)
		{
			throw new DatapoolException(Messages.getString("DPLRecordImpl.1") + cellIndex); //$NON-NLS-1$
		}
	}
	
	/**
	 * The value for the cell in the current record and
	 * the specified variable is returned.  The variable is located by the
	 * specified name, which must match a variable name in the record.  A
	 * {@link DatapoolException} is thrown if the name does not match a variable
	 * name in the record.
	 * 
	 * @param	variableName	The variable name to identify the cell by.
	 * @return	The value for the cell in the current record and
	 *			the specified variable name.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolCell getCell(String variableName)
	{
		
		ListIterator it = this.getCells().listIterator();
		while(it.hasNext()) {
  		
		  DPLCell cell = (DPLCell)it.next();
		  if (variableName.equals(cell.getVariable().getName()))
			return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolCell)cell;
  	  
		}
		throw new DatapoolException(Messages.getString("DPLRecordImpl.2") + variableName);		 //$NON-NLS-1$
	}
	
	/**
	 * convenience method
	 * Insert cell at a given position
	 * @param newCell The value to be inserted
	 * @param position The zero based cell position
	 */
	public void insertCell(DPLCell newCell, int position)
	{
		this.getCells().add(position, newCell);	
	}
	
	/**
	 * Access to the {@link IDatapoolEquivalenceClass equivalenceClass} that is the 
	 * parent of this record.
	 * 
	 * @return	The {@link IDatapoolEquivalenceClass equivalenceClass} that is the 
	 * 			parent of this record.
	 */
	public IDatapoolEquivalenceClass getEquivalenceClass()
	{
		return (IDatapoolEquivalenceClass)this.eContainer();
	}

} //DPLRecordImpl
