/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IImplementor.java,v 1.3 2005/02/16 22:21:15 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * A implementor implements a behavior of a test.  An implementor can be 
 * visualized as the code within the method of a test class.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since
 */
public interface IImplementor extends IDeployableComponent
{
	/**
	 * Returns the block that contains the list of actions to be executed.
	 * If the implementor is external, this method will return null.
	 * 
	 * <p>This reference is unidirectional
	 * 
	 * @return IBlock
	 */
	public IBlock getBlock();

	/**
	 * Identifies if the implementor is external.  External implementor
	 * does not have a block.
	 * 
	 * @return boolean
	 */	
	public boolean isExternalImplementor();

}
