/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITestComponent.java,v 1.5 2005/02/16 22:21:15 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

import java.util.List;

/**
 * 
 * A test component is a utility component that contains one or more implementors 
 * of behaviors.  These contained behaviors may be invoked from test cases or
 * test suites.
 * 
 *
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface ITestComponent extends IDeployableComponent, ITypedElement {
	
	/**
	 * Returns the list of implementors that are contained by this test component.  
	 * Implementors must enforce that all objects in the list are instances of 
	 * {@link IImplementor}.
	 * 
	 * @return List
	 */
	public List getImplementors();
	
}
