/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BVRCombinedFragment.java,v 1.11 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.fragments;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>BVR Combined Fragment</b></em>'.
 * @extends ILoop, IDecision
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A combined fragment defines an expression of interaction fragments. A combined fragment is defined by an interaction
 * operator and corresponding interaction operands. Through the use of CombinedFragments the user will be able
 * to describe a number of traces in a compact and concise manner.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.BVRCombinedFragment#getInteractionOperator <em>Interaction Operator</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.BVRCombinedFragment#getGates <em>Gates</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.BVRCombinedFragment#getInteractionOperands <em>Interaction Operands</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRCombinedFragment()
 * @model 
 * @generated
 */
public interface BVRCombinedFragment extends BVRInteractionFragment, ILoop, IDecision{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Interaction Operator</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.hyades.models.common.fragments.BVRInteractionOperator}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction Operator</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interaction Operator</em>' attribute.
	 * @see org.eclipse.hyades.models.common.fragments.BVRInteractionOperator
	 * @see #setInteractionOperator(BVRInteractionOperator)
	 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRCombinedFragment_InteractionOperator()
	 * @model 
	 * @generated
	 */
	BVRInteractionOperator getInteractionOperator();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.fragments.BVRCombinedFragment#getInteractionOperator <em>Interaction Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interaction Operator</em>' attribute.
	 * @see org.eclipse.hyades.models.common.fragments.BVRInteractionOperator
	 * @see #getInteractionOperator()
	 * @generated
	 */
	void setInteractionOperator(BVRInteractionOperator value);

	/**
	 * Returns the value of the '<em><b>Gates</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.fragments.BVRGate}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Gates</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Gates</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRCombinedFragment_Gates()
	 * @model type="org.eclipse.hyades.models.common.fragments.BVRGate" containment="true"
	 * @generated
	 */
	EList getGates();

	/**
	 * Returns the value of the '<em><b>Interaction Operands</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.fragments.BVRInteractionOperand}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.fragments.BVRInteractionOperand#getCombinedFragment <em>Combined Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction Operands</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interaction Operands</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRCombinedFragment_InteractionOperands()
	 * @see org.eclipse.hyades.models.common.fragments.BVRInteractionOperand#getCombinedFragment
	 * @model type="org.eclipse.hyades.models.common.fragments.BVRInteractionOperand" opposite="combinedFragment" containment="true" required="true"
	 * @generated
	 */
	EList getInteractionOperands();

} // BVRCombinedFragment
