/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BVRMessageEnd.java,v 1.10 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.interactions;

import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>BVR Message End</b></em>'.
 * @extends ITargetInvocation
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A MessageEnd is an abstract concept that represents what can occur at the end of a Message.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getReceiveMessage <em>Receive Message</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getSendMessage <em>Send Message</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessageEnd()
 * @model 
 * @generated
 */
public interface BVRMessageEnd extends BVREventOccurrence, ITargetInvocation{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Receive Message</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getReceiveMessageEnd <em>Receive Message End</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Receive Message</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Receive Message</em>' reference.
	 * @see #setReceiveMessage(BVRMessage)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessageEnd_ReceiveMessage()
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage#getReceiveMessageEnd
	 * @model opposite="receiveMessageEnd"
	 * @generated
	 */
	BVRMessage getReceiveMessage();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getReceiveMessage <em>Receive Message</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Receive Message</em>' reference.
	 * @see #getReceiveMessage()
	 * @generated
	 */
	void setReceiveMessage(BVRMessage value);

	/**
	 * Returns the value of the '<em><b>Send Message</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getSendMessageEnd <em>Send Message End</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Send Message</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Send Message</em>' reference.
	 * @see #setSendMessage(BVRMessage)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessageEnd_SendMessage()
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage#getSendMessageEnd
	 * @model opposite="sendMessageEnd"
	 * @generated
	 */
	BVRMessage getSendMessage();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getSendMessage <em>Send Message</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Send Message</em>' reference.
	 * @see #getSendMessage()
	 * @generated
	 */
	void setSendMessage(BVRMessage value);

} // BVRMessageEnd
