/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Common_Behavior_InteractionsSwitch.java,v 1.10 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.interactions.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.common.common.CMNNamedElement;

import org.eclipse.hyades.models.common.interactions.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage
 * @generated
 */
public class Common_Behavior_InteractionsSwitch {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static Common_Behavior_InteractionsPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Common_Behavior_InteractionsSwitch() {
		if (modelPackage == null) {
			modelPackage = Common_Behavior_InteractionsPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch((EClass)eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case Common_Behavior_InteractionsPackage.BVR_LIFELINE: {
				BVRLifeline bvrLifeline = (BVRLifeline)theEObject;
				Object result = caseBVRLifeline(bvrLifeline);
				if (result == null) result = caseCMNNamedElement(bvrLifeline);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE: {
				BVRMessage bvrMessage = (BVRMessage)theEObject;
				Object result = caseBVRMessage(bvrMessage);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_Behavior_InteractionsPackage.BVR_GENERAL_ORDERING: {
				BVRGeneralOrdering bvrGeneralOrdering = (BVRGeneralOrdering)theEObject;
				Object result = caseBVRGeneralOrdering(bvrGeneralOrdering);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE: {
				BVREventOccurrence bvrEventOccurrence = (BVREventOccurrence)theEObject;
				Object result = caseBVREventOccurrence(bvrEventOccurrence);
				if (result == null) result = caseBVRInteractionFragment(bvrEventOccurrence);
				if (result == null) result = caseCMNNamedElement(bvrEventOccurrence);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END: {
				BVRMessageEnd bvrMessageEnd = (BVRMessageEnd)theEObject;
				Object result = caseBVRMessageEnd(bvrMessageEnd);
				if (result == null) result = caseBVREventOccurrence(bvrMessageEnd);
				if (result == null) result = caseBVRInteractionFragment(bvrMessageEnd);
				if (result == null) result = caseCMNNamedElement(bvrMessageEnd);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE: {
				BVRExecutionOccurrence bvrExecutionOccurrence = (BVRExecutionOccurrence)theEObject;
				Object result = caseBVRExecutionOccurrence(bvrExecutionOccurrence);
				if (result == null) result = caseBVRInteractionFragment(bvrExecutionOccurrence);
				if (result == null) result = caseCMNNamedElement(bvrExecutionOccurrence);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_Behavior_InteractionsPackage.BVR_STATE_INVARIANT: {
				BVRStateInvariant bvrStateInvariant = (BVRStateInvariant)theEObject;
				Object result = caseBVRStateInvariant(bvrStateInvariant);
				if (result == null) result = caseBVRInteractionFragment(bvrStateInvariant);
				if (result == null) result = caseCMNNamedElement(bvrStateInvariant);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_Behavior_InteractionsPackage.BVR_STOP: {
				BVRStop bvrStop = (BVRStop)theEObject;
				Object result = caseBVRStop(bvrStop);
				if (result == null) result = caseBVREventOccurrence(bvrStop);
				if (result == null) result = caseBVRInteractionFragment(bvrStop);
				if (result == null) result = caseCMNNamedElement(bvrStop);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_Behavior_InteractionsPackage.BVR_PROPERTY: {
				BVRProperty bvrProperty = (BVRProperty)theEObject;
				Object result = caseBVRProperty(bvrProperty);
				if (result == null) result = caseCMNNamedElement(bvrProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR Lifeline</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR Lifeline</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVRLifeline(BVRLifeline object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR Interaction Fragment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR Interaction Fragment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVRInteractionFragment(BVRInteractionFragment object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR Message</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR Message</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVRMessage(BVRMessage object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR General Ordering</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR General Ordering</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVRGeneralOrdering(BVRGeneralOrdering object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR Event Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR Event Occurrence</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVREventOccurrence(BVREventOccurrence object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR Message End</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR Message End</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVRMessageEnd(BVRMessageEnd object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR Execution Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR Execution Occurrence</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVRExecutionOccurrence(BVRExecutionOccurrence object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR State Invariant</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR State Invariant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVRStateInvariant(BVRStateInvariant object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR Stop</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR Stop</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVRStop(BVRStop object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>BVR Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>BVR Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBVRProperty(BVRProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>CMN Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>CMN Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCMNNamedElement(CMNNamedElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //Common_Behavior_InteractionsSwitch
