/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TPFBehavior.java,v 1.12 2005/03/28 21:51:31 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import org.eclipse.hyades.models.common.common.CMNNamedElement;

import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TPF Behavior</b></em>'.
 * @extends IImplementor
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Behavior represents the dynamic behavior of a TestSuite, TestCase, TestComponent used to test an SUT, or Arbiter. In the context of a TestCase, it represents the composite behavior of the different TestComponents realizing the test, and/or the behavior of the TestCase in the case where the TestSuite classifier interacts directly with the SUT.
 * 
 * In the Hyades meta-model Behaviors are modeled using Interactions (i.e. Sequence Diagrams) enabling the easy modeling of composite behaviors.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getInteraction <em>Interaction</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getIsReentrant <em>Is Reentrant</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getResource <em>Resource</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getLocation <em>Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getArbiter <em>Arbiter</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getTestComponent <em>Test Component</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getTest <em>Test</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFBehavior()
 * @model 
 * @generated
 */
public interface TPFBehavior extends CMNNamedElement, IImplementor{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Is Reentrant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Reentrant</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Is Reentrant</em>' attribute.
	 * @see #setIsReentrant(Boolean)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFBehavior_IsReentrant()
	 * @model 
	 * @generated
	 */
	Boolean getIsReentrant();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getIsReentrant <em>Is Reentrant</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Is Reentrant</em>' attribute.
	 * @see #getIsReentrant()
	 * @generated
	 */
	void setIsReentrant(Boolean value);

	/**
	 * Returns the value of the '<em><b>Resource</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Resource</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Resource</em>' attribute.
	 * @see #setResource(String)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFBehavior_Resource()
	 * @model 
	 * @generated
	 */
	String getResource();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getResource <em>Resource</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Resource</em>' attribute.
	 * @see #getResource()
	 * @generated
	 */
	void setResource(String value);

	/**
	 * Returns the value of the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Location</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Location</em>' attribute.
	 * @see #setLocation(String)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFBehavior_Location()
	 * @model 
	 * @generated
	 */
	String getLocation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getLocation <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Location</em>' attribute.
	 * @see #getLocation()
	 * @generated
	 */
	void setLocation(String value);

	/**
	 * Returns the value of the '<em><b>Interaction</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.fragments.BVRInteraction#getBehavior <em>Behavior</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interaction</em>' containment reference.
	 * @see #setInteraction(BVRInteraction)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFBehavior_Interaction()
	 * @see org.eclipse.hyades.models.common.fragments.BVRInteraction#getBehavior
	 * @model opposite="behavior" containment="true"
	 * @generated
	 */
	BVRInteraction getInteraction();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getInteraction <em>Interaction</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interaction</em>' containment reference.
	 * @see #getInteraction()
	 * @generated
	 */
	void setInteraction(BVRInteraction value);

	/**
	 * Returns the value of the '<em><b>Arbiter</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFArbiter#getBehaviors <em>Behaviors</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Arbiter</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Arbiter</em>' container reference.
	 * @see #setArbiter(TPFArbiter)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFBehavior_Arbiter()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFArbiter#getBehaviors
	 * @model opposite="behaviors"
	 * @generated
	 */
	TPFArbiter getArbiter();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getArbiter <em>Arbiter</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Arbiter</em>' container reference.
	 * @see #getArbiter()
	 * @generated
	 */
	void setArbiter(TPFArbiter value);

	/**
	 * Returns the value of the '<em><b>Test Component</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFTestComponent#getBehaviors <em>Behaviors</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test Component</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Test Component</em>' container reference.
	 * @see #setTestComponent(TPFTestComponent)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFBehavior_TestComponent()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFTestComponent#getBehaviors
	 * @model opposite="behaviors"
	 * @generated
	 */
	TPFTestComponent getTestComponent();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getTestComponent <em>Test Component</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Test Component</em>' container reference.
	 * @see #getTestComponent()
	 * @generated
	 */
	void setTestComponent(TPFTestComponent value);

	/**
	 * Returns the value of the '<em><b>Test</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFTest#getBehavior <em>Behavior</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Test</em>' container reference.
	 * @see #setTest(TPFTest)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFBehavior_Test()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFTest#getBehavior
	 * @model opposite="behavior"
	 * @generated
	 */
	TPFTest getTest();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getTest <em>Test</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Test</em>' container reference.
	 * @see #getTest()
	 * @generated
	 */
	void setTest(TPFTest value);

} // TPFBehavior
