/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestEnumerations.java,v 1.3 2005/02/16 22:21:22 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.util;

import java.util.Iterator;

import org.eclipse.hyades.models.common.configuration.CFGConcurrency;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperator;
import org.eclipse.hyades.models.common.interactions.BVRMessageSort;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationReason;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationStatus;
import org.eclipse.hyades.models.common.testprofile.TPFSeverity;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictReason;

/**
 * This class prints the name and label of all the Enumerations in this plugin.
 * It must be executed within the Eclipse context.
 * 
 * @author marcelop
 * @since 0.3.0
 */
public class TestEnumerations
{
	public static void printEnumerations()
	{
		System.out.println(TPFVerdict.class.getName());
		for (Iterator i = TPFVerdict.VALUES.iterator(); i.hasNext();)
		{
			TPFVerdict enum = (TPFVerdict)i.next();
			System.out.println("\t" + enum.getName() + " - " + enum.getLabel());
		}		

		System.out.println(TPFExecutionType.class.getName());
		for (Iterator i = TPFExecutionType.VALUES.iterator(); i.hasNext();)
		{
			TPFExecutionType enum = (TPFExecutionType)i.next();
			System.out.println("\t" + enum.getName() + " - " + enum.getLabel());
		}	
		
		System.out.println(TPFSeverity.class.getName());
		for (Iterator i = TPFSeverity.VALUES.iterator(); i.hasNext();)
		{
			TPFSeverity enum = (TPFSeverity)i.next();
			System.out.println("\t" + enum.getName() + " - " + enum.getLabel());
		}		

		System.out.println(TPFVerdictReason.class.getName());
		for (Iterator i = TPFVerdictReason.VALUES.iterator(); i.hasNext();)
		{
			TPFVerdictReason enum = (TPFVerdictReason)i.next();
			System.out.println("\t" + enum.getName() + " - " + enum.getLabel());
		}			

		System.out.println(TPFInvocationStatus.class.getName());
		for (Iterator i = TPFInvocationStatus.VALUES.iterator(); i.hasNext();)
		{
			TPFInvocationStatus enum = (TPFInvocationStatus)i.next();
			System.out.println("\t" + enum.getName() + " - " + enum.getLabel());
		}		

		System.out.println(TPFInvocationReason.class.getName());
		for (Iterator i = TPFInvocationReason.VALUES.iterator(); i.hasNext();)
		{
			TPFInvocationReason enum = (TPFInvocationReason)i.next();
			System.out.println("\t" + enum.getName() + " - " + enum.getLabel());
		}			

		System.out.println(CFGConcurrency.class.getName());
		for (Iterator i = CFGConcurrency.VALUES.iterator(); i.hasNext();)
		{
			CFGConcurrency enum = (CFGConcurrency)i.next();
			System.out.println("\t" + enum.getName() + " - " + enum.getLabel());
		}		

		System.out.println(BVRInteractionOperator.class.getName());
		for (Iterator i = BVRInteractionOperator.VALUES.iterator(); i.hasNext();)
		{
			BVRInteractionOperator enum = (BVRInteractionOperator)i.next();
			System.out.println("\t" + enum.getName() + " - " + enum.getLabel());
		}			

		System.out.println(BVRMessageSort.class.getName());
		for (Iterator i = BVRMessageSort.VALUES.iterator(); i.hasNext();)
		{
			BVRMessageSort enum = (BVRMessageSort)i.next();
			System.out.println("\t" + enum.getName() + " - " + enum.getLabel());
		}			
	}	
}
