/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TimedEvent.java,v 1.3 2005/02/16 22:21:34 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

import org.eclipse.hyades.test.common.util.XMLUtil;

/**
 * This is a flat class packaged in the execution environment and
 * it mirrors the 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFTimedEvent}.
 * 
 * @author akmathur
 * @since 3.0
 */
public class TimedEvent extends ExecutionEvent {
	
	private long endTimestamp = 0;

	/**
	 * @return Returns the endTimestamp.
	 */
	public long getEndTimestamp() {
		return endTimestamp;
	}
	
	/**
	 * @param endTimestamp The endTimestamp to set.
	 */
	public void setEndTimestamp(long endTimestamp) {
		this.endTimestamp = endTimestamp;
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.event.ExecutionEvent#getXMLRoot()
	 */
	protected String getXMLRoot() {
		return "timedEvent";
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.event.ExecutionEvent#addXMLAttributes(java.lang.StringBuffer)
	 */
	protected void addXMLAttributes(StringBuffer xml) {
		super.addXMLAttributes(xml);
		
		long ts = getEndTimestamp();
		if(ts == 0)
			ts = System.currentTimeMillis();
		xml.append((XMLUtil.createXMLAttribute("endTimestamp", Long.toString(ts), false)).toString());
	}
}
