/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: VerdictEvent.java,v 1.7 2005/02/16 22:21:34 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

import org.eclipse.hyades.test.common.util.XMLUtil;

/**
 * This is a flat class packaged in the execution environment and
 * it mirrors the 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent}.
 * 
 * @author kobylin
 * @author marcelop
 */
public class VerdictEvent 
extends ExecutionEvent
{
	public static final int VERDICT_INCONCLUSIVE = 0;
	public static final int VERDICT_PASS = 1;
	public static final int VERDICT_FAIL = 2;
	public static final int VERDICT_ERROR = 3;

	public static final int REASON_UNKNOWN = 0;
	public static final int REASON_NONE = 1;
	public static final int REASON_SEE_DESCRIPTION = 2;
	public static final int REASON_ABORT = 3;
	public static final int REASON_DID_NOT_COMPLETE = 4;

	private int verdict = NOT_INITIALIZED_VALUE;
	private int reason = NOT_INITIALIZED_VALUE;
	private String causedBy = null;
	
	/**
	 * Sets the verdict of this event.
	 * @param value
	 */
	public void setVerdict(int value)
	{
		verdict = value;
	}

	/**
	 * Returns the verdict of this event.
	 * @return int
	 */
	public int getVerdict()
	{
		return verdict;
	}


	/**
	 * Sets the reason for the status of this event.
	 * @param value
	 */
	public void setReason(int value)
	{
		reason = value;
	}

	/**
	 * Returns the reason for the status of this event.
	 * @return int
	 */
	public int getReason()
	{
		return reason;
	}
	
	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#getXMLRoot()
	 */
	protected String getXMLRoot()
	{
		return "verdictEvent";
	}

	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#addXMLAttributes(java.lang.StringBuffer)
	 */
	protected void addXMLAttributes(StringBuffer xml)
	{
		super.addXMLAttributes(xml);
		
		if(getVerdict() != NOT_INITIALIZED_VALUE)
			xml.append((XMLUtil.createXMLAttribute("verdict", Integer.toString(getVerdict()), false)).toString());
		if(getReason() != NOT_INITIALIZED_VALUE)
			xml.append((XMLUtil.createXMLAttribute("reason", Integer.toString(getReason()), false)).toString());
		if(getCausedBy() != null)
			xml.append((XMLUtil.createXMLAttribute("causedBy", getCausedBy(), false)).toString());
			
	}	
	/**
	 * @return
	 */
	public String getCausedBy() {
		return causedBy;
	}

	/**
	 * @param string
	 */
	public void setCausedBy(String string) {
		causedBy = string;
	}

}
