/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: ExecutionComponentStateException.java,v 1.4 2005/02/16 22:20:05 qiyanli Exp $

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
    SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/** 
 * A ExecutionComponentStateException is thrown by any IExecutionComponent
 * operation that occurs when the IExecutionComponent is not in the correct
 * state to support the current operation.
 * @version 0.0.2
 */

public class ExecutionComponentStateException extends RuntimeException {
	
	private int state;
	private Throwable cause;
	
	/** 
	 * @param state the state of the exception
	 * @param message a description of the condition that caused this exception to
	 *        be thrown 
	 */
	public ExecutionComponentStateException(int state, String message) {
		super(message);
		this.state=state;
	}
	
	/** 
	 * @param state the state of the exception
	 * @param message a description of the condition that caused this exception to
	 *        be thrown
	 * @param cause a <code>Throwable</code> that represents the underlying cause
	 *        of this exception having been thrown
	 */
	public ExecutionComponentStateException(int state, String message, Throwable cause) {
		super(message);
		this.state = state;
		this.cause = cause;
	}
	
	/** 
	 * @param state the state of the exception
	 * @param cause a <code>Throwable</code> that represents the underlying cause
	 *        of this exception having been thrown
	 */
	public ExecutionComponentStateException(int state, Throwable cause) {
		super();
		this.cause = cause;
	}
	
	/** 
	 * @return The state of the exception
	 */
	public int getState() {
		return state;
	}
	
	/**
	 * @return a <code>Throwable</code> that represents the underlying cause of
	 *         this exception having been thrown
	 */	
	public Throwable getCause() {
		return cause;
	}

}
