/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: IEclipseExecutionComponentFactory.java,v 1.3 2005/02/16 22:20:05 qiyanli Exp $

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

import org.eclipse.core.runtime.IConfigurationElement;

/**
 * This interface defines a factory for IExecutionComponents.  The mechanism by 
 * which this factory is extended to support multiple implementations of the 
 * same execution component type has not yet been resolved.
 * @version 0.0.2
 */
public interface IEclipseExecutionComponentFactory {
	
	/**
	 * @param type The type of execution component to create
	 * @return IExecutionComponent The created IExecutionComponent
	 */
	public IExecutionComponent createExecutionComponentByType(String type);
	
	/**
	 * Loads a type into the factory's creation table.  This routine will
	 * determine if the implementation class is available in the appropriate
	 * locations.  If the factory is responsible for creating remote instances
	 * tehn it needs to check both the local and the remote classpaths for the 
	 * implementation class.
	 * @param configElement an Eclipse IConfigurationElement of the 
	 * 	RegisteredExecutionComponentImpl schema for the execution component.  
	 * the implementation class, stub, and skeleton must all have default constructors.
	 * @throws ClassNotFoundException if the class is not available in any of the
	 * locations where it is required.
	 */
	public void addExecutionComponent(IConfigurationElement configElement) throws ClassNotFoundException;
	
	public ISession getSessionContext();

}
