/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: IOrderedProperty.java,v 1.4 2005/02/16 22:20:05 qiyanli Exp $

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/**
 *
 * A IOrderedProperty is a property that may have many ordered values.
 * @version 0.0.2
 */
public interface IOrderedProperty extends Cloneable {

	/**
	 * Sets the name of the property
	 * @param name The name of the property
	 */
	public void setName(String name);

	/**
	 * Gets the name of the property
	 * @return The name of the property
	 */
	public String getName();

	/**
	 * Appends a value to a property's value list.
	 * @param value The value to append
	 */
	public void appendValue(Object value);

	/**
	 * Prepend a value to a property's value list.
	 * @param value The value to prepend
	 */
	public void prependValue(Object value);

	/**
	 * Retrieve the ordered list of values.
	 * @return Object[] the current value(s).
	 */
	public Object[] getValues();

	/**
	 * Clears a propery.
	 * @return Object[] the previously set value(s).
	 */
	public Object[] clear();


}
