/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: IProcessConsole.java,v 1.4 2005/02/16 22:20:05 qiyanli Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author IBM
 *
 * This is an interface for the console handler
 */
public interface IProcessConsole {

	/**
	 * Get the standard input stream for writing to console
	 * @return OutputStream
	 */
	OutputStream getStandardInputStream();

	/**
	 * Get the standard output stream for reading from console
	 * @return InputStream
	 */
	InputStream getStandardOutputStream();

	/**
	 * Get the standard error stream for reading from console
	 * @return InputStream
	 */
	InputStream getStandardErrorStream();

}
