/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RemoteObjectReference.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.invocation;

import java.io.Serializable;

/**
 * This type serves as a remote object reference. When remote objects are passed
 * as method arguments, they are passed by reference. Custom input and output
 * serialization streams make use of insances of this type.
 */
public class RemoteObjectReference implements Serializable {
	
	private Integer uniqueId;
	
	/**
	 * Create a reference to the remote object associated with
	 * <code>uniqueId</code>
	 * 
	 * @param uniqueId
	 */
	public RemoteObjectReference(Integer uniqueId) {
		this.uniqueId = uniqueId;
	}
	
	/**
	 * Get the object referred to by this reference.
	 * 
	 * @return
	 */
	public Object getReferencedObject() {
		Object refObj = Marshaller.getInstanceFromMap(uniqueId);
		if ( refObj == null )
			throw new IllegalStateException("The referenced remote object could not be found");
		return refObj;
	}

}
