/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: AbstractServerInterrogationCommand.java,v 1.2 2005/05/05 19:52:37 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

/**
 * Superclass to commands that inspect the server itself rather than the files
 * managed by the server, this is basically more of a meta file server command
 * rather than a file server command.
 * 
 * @author Scott E. Schneider
 */
abstract class AbstractServerInterrogationCommand extends AbstractFileServerCommand implements IServerInterrogationCommand {

	AbstractServerInterrogationCommand(Class identity) {
		super(identity);
	}

	abstract class Client extends AbstractFileServerCommand.Client {

		Client(ISocketChannel channel) {
			super(channel);
		}

	}

	abstract class Server extends AbstractFileServerCommand.Server {

		Server(ISocketChannel channel) {
			super(channel);
		}

	}

}
