/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IHyadesTestNavigatorFilter.java,v 1.3 2005/02/16 22:21:51 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.test.ui;

import org.eclipse.core.runtime.IExecutableExtension;

/**
 * <p>Interface used to filter element in the Hyades Test Navigator.
 * This interface should be implemented by tool vendor and used in the
 * org.eclipse.hyades.test.ui.testNavigatorFilter extension point.
 * <p>The only one method to be implemented is <code>isFiltered</code>, 
 * this method returns <code>true</code> if the object parameter should 
 * be filtered in the tree and <code>false</code> if it should be diplayed.
 *  
 * @author jgout
 */

public interface IHyadesTestNavigatorFilter extends IExecutableExtension {
	
	/** Method to implement filters of objects found in the test navigator.
	 * @param object Object found in the test navigator content providers (this object is a child of the displayed element).
	 * @return <code>true</code> if the parameter <code>object</code> should be filtered by the navigator and <code>false</code> otherwize.
	 */
	public boolean isFiltered(Object object);

}
