/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program
 * and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * available at $Id: FeatureChildrenSelectionAction.java,v 1.3 2005/02/16 22:22:04 qiyanli Exp $ Contributors: IBM -
 * Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.test.ui.action.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * @author bjiang
 * @since  3.0
 */
public class FeatureChildrenSelectionAction extends ChildrenSelectionAction 
{
	private EObject parent;
	private EStructuralFeature eStructuralFeature;
	
	/**
	 * Constructs an instance of this class that handles the selection of EStructuralFeature of the 
	 * specified parent.  
	 * @param text
	 * @param parent
	 * @param feature
	 * 
	 * @author bjiang
	 */
	public FeatureChildrenSelectionAction(String text, EObject parent, EStructuralFeature feature)
	{
		super(text);
		this.parent = parent;
		//if(feature.isMany())
			this.eStructuralFeature = feature;
	}
	
	public EStructuralFeature getEStructuralFeature()
	{
	    return this.eStructuralFeature;
	}
	
	public EObject getParent()
	{
	    return this.parent;
	}
	
	/**
	 * Returns the value of the EStructuralFeature of the parent or <code>null</code> if either 
	 * the parent or EStructuralFeature is <code>null</code>.
	 */
	protected Object getEStructuralFeatureValue()
	{
		if(parent == null || eStructuralFeature == null)
			return null;
			
		return parent.eGet(eStructuralFeature);
	}
	
	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection)
	{
		setActionPerformed(false);
		List children = getChildren();
		if(children != null)
		    children.clear();
		
		if(selection.isEmpty())
			return false;
		
		List childCandidates = new ArrayList();
		for (Iterator i = selection.iterator(); i.hasNext();)
		{
			Object object = i.next();
			if(!(object instanceof EObject))
				return false;
				
			//if(((EObject)object).eContainer() == null)
				//return false;
				
			childCandidates.add(object);
		}
		
		children.addAll(childCandidates);
		return !children.isEmpty();
	}
}
