/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolEquivalenceClassPropertySource.java,v 1.3 2005/02/16 22:22:04 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/**
 * This class is a {@link org.eclipse.ui.views.properties.IPropertySource2 IPropertySource2}
 * implemented for {@link org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass IDatapoolEquivalenceClass}.
 * 
 * @author bjiang
 * @since  3.3
 */
public class DatapoolEquivalenceClassPropertySource extends
        NamedElementPropertySource
{
    public static final String PROPERTY_SOURCE_ISDEFAULT = "datapool.equivalenceClass.propertySource.isDefault";
    
    private IPropertyDescriptor isDefaultPropertyDescriptor;
    
    /**
     * @param namedElement
     */
    public DatapoolEquivalenceClassPropertySource(IDatapoolEquivalenceClass namedElement)
    {
        super(namedElement);
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyDescriptors()
     */
    public IPropertyDescriptor[] getPropertyDescriptors()
    {
        IPropertyDescriptor[] common = super.getPropertyDescriptors();
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[common.length + 1];
        System.arraycopy(common, 0, descriptors, 0, common.length);
        common = null;
        descriptors[descriptors.length - 1] = getIsDefaultPropertyDescriptor();;
        return descriptors;
    }
    
    private IPropertyDescriptor getIsDefaultPropertyDescriptor()
    {
        /*if(this.isDefaultPropertyDescriptor == null)
        {
            isDefaultPropertyDescriptor = new ComboBoxPropertyDescriptor(PROPERTY_SOURCE_NAME, TestUIPlugin.getString("Word.Name"), new String[]{TestUIPlugin.getString("Word.No"), TestUIPlugin.getString("Word.Yes")}); //$NON-NLS-1$
            ((PropertyDescriptor)isDefaultPropertyDescriptor).setCategory(TestUIPlugin.getString("Word.Attributes")); //$NON-NLS-1$
        }
        return isDefaultPropertyDescriptor;*/
        return null;
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.ui.views.properties.IPropertySource#setPropertyValue(java.lang.Object, java.lang.Object)
     */
    public void setPropertyValue(Object id, Object value)
    {
        //if(PROPERTY_SOURCE_ISDEFAULT.equals(id))
        {
            //((IDatapool)((DPLEquivalenceClass)getNamedElement()).getDatapool()).setDefaultEquivalenceClassIndex();
        }
        super.setPropertyValue(id, value);
    }
}
