/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCasesForm.java,v 1.5 2005/02/16 22:22:05 qiyanli Exp $
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.extension.TestSuiteEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.base.IHasEStructuralFeature;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.action.AddTestCaseAction;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author marcelop, bcormier
 * @since 3.0.0
 */
public class TestCasesForm
extends EditorForm implements ISelectionChangedListener, IHasEStructuralFeature
{
	private EObjectTreeSection testCasesSection;
	private NamedElementSection namedElementSection;
	private AddTestCaseAction addTestCaseAction;
	private boolean firstActivation = true;

	/**
	 * Constructor for the test cases form.
	 * @param testSuiteEditorExtension the parent test context editor
	 * @param widgetFactory	the parent widget factory
	 */
	public TestCasesForm(BaseEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory)
	{
		super(testSuiteEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_TST_CASES")); //$NON-NLS-1$
	}

	/**
	 * Dispose the widgets.
	 */
	public void dispose()
	{
		testCasesSection.getTreeViewer().removeSelectionChangedListener(this);
		testCasesSection.dispose();
		namedElementSection.dispose();
		addTestCaseAction.dispose();

		super.dispose();
	}

	/**
	 * Returns the test context manipulated by this form.
	 * @return TPFTestSuite the test context
	 */
	protected TPFTestSuite getTestSuite()
	{
		return ((TestSuiteEditorExtension)getBaseEditorExtension()).getTestSuite();
	}

	/**
	 * Creates the control and adds a help handler to the control.
	 * @return Control the created control
	 * @see org.eclipse.hyades.test.ui.editor.form.util.EditorForm#createControl()
	 */
	public Control createControl()
	{
		Control control = super.createControl();
		WorkbenchHelp.setHelp(getControl(), TestUIPlugin.getID() + ContextIds.TESTCASE_FORM);
		return control;
	}

	/**
	 * Creates the contents of this editor form.
	 * @param parent the parent composite
	 * @see org.eclipse.hyades.test.ui.editor.form.util.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);

		addTestCaseAction = new AddTestCaseAction();
		testCasesSection = new EObjectTreeSection(this, Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), addTestCaseAction);
		registerSection(testCasesSection);
		testCasesSection.setHeaderText(TestUIPlugin.getString("W_TST_CASES")); //$NON-NLS-1$
		testCasesSection.setCollapsable(true);
		Control control = testCasesSection.createControl(leftColumn, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.TESTCASE_SECT_FORM);
		WorkbenchHelp.setHelp(testCasesSection.getTreeViewer().getControl(), TestUIPlugin.getID() + ContextIds.TESTCASE_TREE_FORM);

		namedElementSection = new NamedElementSection(this);
		namedElementSection.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO")); //$NON-NLS-1$
		registerSection(namedElementSection);
		control = namedElementSection.createControl(rightColumn, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.TESTCASE_NAME_FORM);
	}

	/**
	 * Used to load the persisted values in the controls in this method.  
	 * @see org.eclipse.hyades.test.ui.editor.form.util.EditorForm#load()
	 */
	public void load()
	{
		addTestCaseAction.setTestSuite(getTestSuite());

		testCasesSection.getTreeViewer().removeSelectionChangedListener(this);
		testCasesSection.setInput(getTestSuite());
		testCasesSection.getTreeViewer().addSelectionChangedListener(this);
	}

	/**
	 * Reveals and selects the given element within this target view.
	 * @param selection the new element to select
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		testCasesSection.selectReveal(selection);
	}

	/**
	 * Notifies that the selection has changed.
	 * @param event event object describing the change
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event)
	{
		if(event.getSource() == testCasesSection.getTreeViewer())
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)getSelection();
			namedElementSection.setInput(structuredSelection);
		}
	}

	/**
	 * Returns the current selection for this editor extension.
	 * @return the current selection
	 */
	public ISelection getSelection()
	{
		return testCasesSection.getTreeViewer().getSelection();
	}

	/**
	 * Returns whether this form has been activated yet.
	 * @return the activation state
	 */
	public boolean activated()
	{
		if(firstActivation)
		{
			firstActivation = false;
			testCasesSection.setFocus();
		}

		return super.activated();
	}

	/**
	 * Returns the structural feature of this test case form. i.e. the test cases structural feature.
	 * @return the structural feature that corresponds to test cases
	 * @see org.eclipse.hyades.test.ui.editor.form.IHasEStructuralFeature#getStructuralFeature()
	 */
	public EStructuralFeature getStructuralFeature() {
		return Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases();
	}

}
