/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolChildrenListSection.java,v 1.3 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.adapter.PropertySourceLabelProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ListSection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.SelectionListenerAction;

/**
 * This class defines a list section for datapool <i>Equivalence Class</i>
 * and <i>Variable</i> in datapool editor.
 * 
 * @author bjiang
 */
public class DatapoolChildrenListSection extends ListSection
{
    private IAction[] buttonActions;
	private IContentProvider contentProvider;
	private ILabelProvider labelProvider;
	
	class DatapoolChildrenContentProvider implements IStructuredContentProvider
	{
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {
			if(inputElement instanceof IDatapool)
				return DatapoolChildrenListSection.this.getElements((IDatapool)inputElement);
			else
				return new Object[0];
		}
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			DatapoolChildrenListSection.this.inputChanged(viewer, oldInput, newInput);
		}
		
        /* (non-Javadoc)
         * @see org.eclipse.jface.viewers.IContentProvider#dispose()
         */
        public void dispose()
        {
            // TODO Auto-generated method stub

        }
	}
	
	/**
	 * @param editorForm
	 * @param buttonActions
	 * @param listStyle
	 */
	public DatapoolChildrenListSection(EditorForm editorForm, IAction[] buttonActions, int listStyle) {
		super(editorForm);

		this.buttonActions = buttonActions;
		String[] buttonLabels = new String[buttonActions.length];
		for(int i = 0; i < buttonActions.length; i++)
		{
			buttonLabels[i] = buttonActions[i].getText();
		}
		super.setButtonLabels(buttonLabels);
	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection#dispose()
	 */
	public void dispose() {
		for(int i = 0; i < buttonActions.length; i++)
		{
			if(buttonActions[i] != null)
				buttonActions[i] = null;
		}
		super.dispose();
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseTreeSection#adjustClient(org.eclipse.swt.widgets.Composite)
	 */
	protected void adjustClient(Composite parent)
	{		
		getListViewer().setContentProvider(getContentProvider());
		getListViewer().setLabelProvider(getLabelProvider());

		/*getTreeViewer().getTree().addFocusListener(new FocusAdapter() {
			 (non-Javadoc)
			 * @see org.eclipse.swt.events.FocusAdapter#focusGained(org.eclipse.swt.events.FocusEvent)
			 
			public void focusGained(FocusEvent e) {
				getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().setSelectionProvider(getTreeViewer());
				super.focusGained(e);
			}
		});*/
		getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().setSelectionProvider(getListViewer());
		
		for(int i = 0; i < buttonActions.length; i++)
		{
			if(buttonActions[i] != null)
			{
				getViewerPart().setButtonEnabled(i, buttonActions[i].isEnabled());
			}
		}
	}
	
	protected IContentProvider getContentProvider()
	{
		if(this.contentProvider == null)
			contentProvider = new DatapoolChildrenContentProvider();
		
		return contentProvider;
	}
	
	protected ILabelProvider getLabelProvider()
	{
		if(this.labelProvider == null)
			labelProvider = new PropertySourceLabelProvider();
		
		return labelProvider;
	}

	protected Object[] getElements(IDatapool inputElement)
	{
	    return new Object[0];
	}
	protected void inputChanged(Viewer viewer, Object oldInput, Object newInput) 
	{
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#buttonSelected(int)
	 */
	protected void buttonSelected(int index)
	{
		if(!isReadOnly())
		{
			if( index >=0 && index < buttonActions.length )
				buttonActions[index].run();
		}
	
		updateActionsAndButtons(getStructuredSelection());
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#updateActionsAndButtons(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected void updateActionsAndButtons(IStructuredSelection structuredSelection)
	{
		if(buttonActions == null || buttonActions.length < 1)
			return;
			
		//if(isEditable())
		{
			for(int i = 0; i < buttonActions.length; i++)
			{
				if(buttonActions[i] != null)
				{
					if(buttonActions[i] instanceof SelectionListenerAction)
						((SelectionListenerAction)buttonActions[i]).selectionChanged(structuredSelection);
					getViewerPart().setButtonEnabled(i, buttonActions[i].isEnabled());
				}
			}
		}
	}
	
	protected void selectionChanged(IStructuredSelection structuredSelection) {
		super.selectionChanged(structuredSelection);
	}
}
