/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EditorForm.java,v 1.4 2005/02/16 22:22:05 qiyanli Exp $
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.part.ISetSelectionTarget;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ScrollableSectionForm;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * @author marcelop
 * @since 3.0.0
 */
public abstract class EditorForm
extends ScrollableSectionForm implements IDisposable, ISetSelectionTarget
{
	protected static class ArgByReference
	{
		public Object arg;
	}
	
	private BaseEditorExtension baseEditorExtension;
	private WidgetFactory widgetFactory;

	/**
	 * Constructor for EditorForm
	 * @param editorExtension
	 * @param widgetFactory
	 */
	public EditorForm(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory)
	{
		this();
		init(baseEditorExtension, widgetFactory);
	}

	public EditorForm()
	{
		super();

		setHeadingImage(TestUIImages.INSTANCE.getImage(TestUIImages.IMG_FORM_BANNER));
		setVerticalFit(true);
	}
	
	public void init(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory)
	{
		this.baseEditorExtension = baseEditorExtension;
		this.widgetFactory = widgetFactory;
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		baseEditorExtension = null;
		widgetFactory = null;
		
		super.dispose();
	}
	
	/**
	 * Updates this editor form title.
	 */
	public void updateTitle()
	{
	}
	
	/**
	 * Creates the control using the attributes of the editor extension
	 * specified in the constructor.
	 * @return Control
	 */
	public Control createControl()
	{
		Control control = createControl(baseEditorExtension.getHyadesEditorPart().getContainer());
		update();
		return control;
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{

	}

	/**
	 * Returns the widget factory.
	 * @return WidgetFactory
	 */
	public WidgetFactory getWidgetFactory()
	{
		return widgetFactory;
	}

	/**
	 * Returns the base editor extension that is presenting this composite.
	 * @return BaseEditorExtension
	 */
	public BaseEditorExtension getBaseEditorExtension()
	{
		return baseEditorExtension;
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.SectionForm#createFormClient(org.eclipse.swt.widgets.Composite)
	 */
	protected void createFormClient(Composite parent)
	{
		parent.setLayout(new GridLayout());
		parent.setLayoutData(GridDataUtil.createFill());
		createEditorFormContents(parent);
		load();
	}
	
	/**
	 * Creates the contents of this editor form.
	 * @param parent
	 */
	abstract protected void createEditorFormContents(Composite parent);

	/**
	 * Subclasses should load the persited values in the controls in this method.  
	 * The goal is to provide a common behavior for the editor forms.
	 */
	abstract public void load();
	
	/**
	 * Creates a composite that corresponds to the a column in the given parent.
	 * @param parent
	 * @return Composite
	 */
	protected Composite createColumn(Composite parent)
	{
		Composite column = getFactory().createComposite(parent);
		column.setLayoutData(GridDataUtil.createFill());
		GridLayout gridLayout = new GridLayout();
		gridLayout.verticalSpacing = 10;
		gridLayout.marginWidth = 0;
		column.setLayout(gridLayout);
		return column;
	}
	
	/**
	 * Returns the editor's status line manager or <code>null</code>
	 * if the manager is not provided.
	 * @return IStatusLineManager
	 */
	protected IStatusLineManager getStatusLineManager()
	{
		IEditorSite editorSite = getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite();
		IActionBars actionBars = editorSite.getActionBars();
		if(actionBars != null)
			return actionBars.getStatusLineManager();
			
		return null;
	}
	
	public boolean activated()
	{
		return false;
	}
	
	public ISelection getCurrentSelection() {
		return null;
	}
}
