/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddArtifactAction.java,v 1.4 2005/02/16 22:22:05 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.wizard.ArtifactNewWizard;
import org.eclipse.hyades.test.ui.internal.wizard.selection.ResourceSelectionWizard;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/**
 * This class handles the action when the Add button of the deployment editor is selected
 * to add a new artifact association.
 * 
 * @author bjiang
 * @since  3.0
 */
public class AddArtifactAction extends AddDeploymentChildAction
{
    /**
	 * Constructor for AddArtifactAction
	 */
	public AddArtifactAction()
	{
		super(TestUIPlugin.getString("BTN_ADD")); //$NON-NLS-1$
		
		setToolTipText(TestUIPlugin.getString("ACT_ART_ADD_TIP")); //$NON-NLS-1$
		setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_ARTIFACT));
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (getDeployment(structuredSelection) != null);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		ArtifactNewWizard artifactNewWizard = new ArtifactNewWizard();
		WizardElement newFileWizardElement = new WizardElement(artifactNewWizard);
		ResourceSelectionWizard fileSelectionWizard = new ResourceSelectionWizard(newFileWizardElement, artifactNewWizard.getFileExtension(), TestUIImages.INSTANCE.getImage(TestUIImages.IMG_ARTIFACT));
		fileSelectionWizard.setWindowTitle(TestUIPlugin.getString("DLG_ASS_ART"));					 //$NON-NLS-1$
		fileSelectionWizard.init(PlatformUI.getWorkbench(), new StructuredSelection());

		Shell parent = Display.getCurrent().getActiveShell();
		WizardDialog dialog = new WizardDialog(parent, fileSelectionWizard);
		dialog.create();
		int ret = dialog.open();
		if(ret == WizardDialog.OK)
		{
			EObject[] eObjects = fileSelectionWizard.getSelectedEObjects();
			if(eObjects != null && eObjects.length > 0)
			{
				TPFDeployment deployment = getDeployment(getStructuredSelection());
				for(int i = 0; i < eObjects.length; i++)
				{
					if(eObjects[i] instanceof CFGArtifact)			
					{
					    if(!ConfigurationUtil.containsById(deployment.getArtifacts(), (CFGArtifact)eObjects[i]))
							deployment.getArtifacts().add((CFGArtifact)eObjects[i]);		
					}						
				}
			}
		}
	}
}
