/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddEquivalenceClassAction.java,v 1.3 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;

/**
 * This class handles <i>Add</i> action in datapool editor to add a new
 * <i>equivalence class</i>.
 * 
 * @author bjiang
 * @since  3.3
 */
public class AddEquivalenceClassAction extends DatapoolEquivalenceClassSelectionAction {
	
    
	/**
	 * Constructor.
	 * @param datapool
	 * @param text
	 */
	public AddEquivalenceClassAction(IDatapool datapool, String text) {
		super(datapool, text);
	}
	
    /* (non-Javadoc)
     * @see org.eclipse.jface.action.Action#run()
     */
    public void run()
    {
        int index = getSelectionIndex();            
        IDatapoolEquivalenceClass eqCls = getParent().constructEquivalenceClass();
        // TODO insert after selection. 
        //if(index > -1 && (index < (getParent().getEquivalenceClassCount() - 1)))
            //getParent().insertEquivalenceClass(eqCls, (index + 1));
        //else
            getParent().appendEquivalenceClass(eqCls);

        eqCls.appendRecord(eqCls.constructRecord());
	}
}
