/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddTestSuiteChildAction.java,v 1.5 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.ui.AddChildAction;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class AddTestSuiteChildAction 
extends AddChildAction
{
	/**
	 * The wizard dialog width
	 */
	protected static final int SIZING_WIZARD_WIDTH = 500;

	/**
	 * The wizard dialog height
	 */
	protected static final int SIZING_WIZARD_HEIGHT = 500;

	/**
	 * Constructor for AddTestSuiteChildAction
	 * @param text
	 */
	public AddTestSuiteChildAction(String text)
	{
		super(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite(), text);
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.ADD_SUITE_CHILD_ACT);												
	}

	protected void  openWizard(TPFTestSuite testSuite, HyadesWizard hyadesWizard, String settingsTag)
	{
		IDialogSettings dialogSettings = TestUIPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection(settingsTag);
		if(settings == null)
			settings = dialogSettings.addNewSection(settingsTag);
		hyadesWizard.setDialogSettings(settings);
		hyadesWizard.init(PlatformUI.getWorkbench(), new StructuredSelection(testSuite));

		Shell parent = Display.getCurrent().getActiveShell();
		WizardDialog dialog = new WizardDialog(parent, hyadesWizard);
		dialog.create();
		dialog.getShell().setSize(Math.max(SIZING_WIZARD_WIDTH, dialog.getShell().getSize().x),	SIZING_WIZARD_HEIGHT);
		setActionPerformed(dialog.open() == Window.OK);		
	}
	
	/**
	 * Sets the default test suite that is returned by 
	 * {@link #getTestSuite(IStructuredSelection)}.  If <code>null</code> then the
	 * selection is analysed in order to identify the test suite.
	 * @param testSuite
	 */
	public void setTestSuite(TPFTestSuite testSuite)
	{
		setParent(testSuite);
	}

	/**
	 * Returns the test suite associated with the first element of the structured 
	 * selection or <code>null</code>.
	 * @param structuredSelection
	 * @return TPFTestSuite
	 */
	protected TPFTestSuite getTestSuite(IStructuredSelection structuredSelection)
	{
		return (TPFTestSuite)getParent(structuredSelection);
	}	
}
