/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddVariableAction.java,v 1.3 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;

/**
 * This class handles <i>Add</i> action in datapool editor to add a new
 * Variable (column).
 * 
 * @author bjiang
 * @since  3.3
 */
public class AddVariableAction extends DatapoolVariableSelectionAction
{

    /**
     * @param datapool
     * @param text
     */
    public AddVariableAction(IDatapool datapool, String text)
    {
        super(datapool, text);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.action.Action#run()
     */
    public void run()
    {
        int index = getSelectionIndex();
		IDatapoolVariable variable = getParent().constructVariable();
		if(index > -1 && index < (getParent().getVariableCount() - 1))
		    getParent().insertVariable(variable, (index + 1));
		else
		    getParent().appendVariable(variable);
	}
}
