/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolVariableSelectionAction.java,v 1.3 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.edit.datapool.INamedElement;
import org.eclipse.hyades.test.ui.adapter.NamedElementPropertySource;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class provides common functions used by datapool actions to manipulate
 * <i>Variables</i> (columns).
 * 
 * @author bjiang
 * @since  3.3
 */
public class DatapoolVariableSelectionAction extends
        DatapoolChildrenSelectionAction
{
    /**
     * @param datapool
     * @param text
     */
    public DatapoolVariableSelectionAction(IDatapool datapool, String text)
    {
        super(datapool, text);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.action.DatapoolChildrenSelectionAction#getChildren()
     */
    protected List getChildren()
    {
        int count = getParent().getVariableCount();
        ArrayList children = new ArrayList();
        for(int i = 0; i < count; i++)
            children.add(getParent().getVariable(i));
        
        return children;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.action.DatapoolChildrenSelectionAction#getSelectionIndex()
     */
    protected int getSelectionIndex()
    {
        int index = getParent().getVariableCount();
        
        IStructuredSelection selection = getStructuredSelection();
        if(selection != null && !selection.isEmpty())
        {
	        Object sel = selection.toList().get(selection.size() - 1);
	        if(sel != null && sel instanceof NamedElementPropertySource)
	        {
	            INamedElement namedElement = ((NamedElementPropertySource)sel).getNamedElement();
	            if(getChildren().contains(namedElement))
	            {
	                index = getParent().getVariableIndexById(((IDatapoolVariable)namedElement).getId());
	            }
	        }
        }
        return index;
    }

}
