/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeleteDatapoolAction.java,v 1.4 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import java.util.Iterator;

import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.jface.viewers.IStructuredSelection;


/**
 * This IAction is used to remove a Datapool record from a table.
 * @author bcormier
 * @since 3.0.0
 *
 */
public class DeleteDatapoolAction extends RemoveChildrenAction {
    private TPFTestSuite testSuite;
    
    /**
     * The constructor for the class
     */
    public DeleteDatapoolAction() {
        super(false);
    }
    
    /**
     * @see org.eclipse.ui.actions.BaseSelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected boolean updateSelection(IStructuredSelection selection) {
		if (selection == null) 
			return false;
			
		if (!(selection.getFirstElement() instanceof DPLDatapool))
		    return false;
		return true;
    }
    
    /**
     * @see org.eclipse.jface.action.IAction#run()
     */
    public void run() {
        if (getTestSuite()==null || getTestSuite().getDatapools()==null) 
            return;
        IStructuredSelection selection = getStructuredSelection();
        for (Iterator iter = selection.iterator(); iter.hasNext();) {
            Object tmp = iter.next();
            if ((tmp instanceof DPLDatapool) && getTestSuite().getDatapools().contains(tmp)) {
                getTestSuite().getDatapools().remove(tmp);
            }
        }
    }

    /**
     * @return Returns the test context.
     */
    public TPFTestSuite getTestSuite() {
        return testSuite;
    }
    
    /**
     * @param testSuite The test context to set.
     */
    public void setTestSuite(TPFTestSuite testSuite) {
        this.testSuite = testSuite;
    }
}
