/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MoveEquivalenceClassUp.java,v 1.3 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class handles <i>Up</i> action in datapool editor to move the position of a
 * <i>equivalence class</i>.
 * 
 * @author bjiang
 * @since  3.3
 */
public class MoveEquivalenceClassUp extends DatapoolEquivalenceClassSelectionAction
{

    /**
     * @param datapool
     * @param text
     */
    public MoveEquivalenceClassUp(IDatapool datapool, String text)
    {
        super(datapool, text);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.action.DatapoolChildrenSelectionAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected boolean updateSelection(IStructuredSelection selection)
    {
        if(!super.updateSelection(selection))
            return false;
        
        return (getSelectionIndex() > 0 ? true : false);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.action.Action#run()
     */
    public void run()
    {
        int index = getSelectionIndex();
        if(index > 0)
            getParent().moveEquivalenceClass(index, (index - 1));
    }
}
