/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolEditorExtension.java,v 1.15 2005/03/02 22:58:51 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPartExtended;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.DataTableForm;
import org.eclipse.hyades.test.ui.internal.editor.form.DatapoolForm;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

/**
 * This class defines <code>IHyadesEditorExtension</code> for datapool editor.
 * 
 * @author psun, bjiang
 */
public class DatapoolEditorExtension extends BaseEditorExtension implements IDatapoolPartExtended {

	private static final int PAGE_OVERVIEW = 0;
	public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Datapool"; //$NON-NLS-1$
	
	private DatapoolForm datapoolForm;
	private ArrayList equivalenceClassPages = new ArrayList();
	
	IDatapoolListener datapoolListener = new DatapoolListener();

	protected class DatapoolListener implements IDatapoolListener
	{
		
		public void cellChanged(IDatapool datapool, int equivalenceClassIndex,
			int recordIndex, int variableIndex) {
		// TODO Auto-generated method stub

		}
		public void equivalenceClassAdded(IDatapool datapool,
				int newEquivalenceClassIndex) {
			addEquivalenceClassPage(newEquivalenceClassIndex);
		}
		public void equivalenceClassChanged(IDatapool datapool,
				int equivalenceClassIndex, String oldName) {
			// TODO Auto-generated method stub

		}
		public void equivalenceClassChanged(IDatapool datapool,
				int equivalenceClassIndex) {
		    IDatapoolEquivalenceClass eqClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(equivalenceClassIndex);
		    int pageIndex = getEquivalenceClassPageIndex(equivalenceClassIndex);
		    getHyadesEditorPart().setPageText(pageIndex, eqClass.getName());
		}
		public void equivalenceClassMoved(IDatapool datapool,
				int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex) {
		    	moveEquivalenceClassPage(sourceEquivalenceClassIndex, targetEquivalenceClassIndex);
		}
		public void equivalenceClassRemoved(IDatapool datapool,
				int equivalenceClassIndex) {
			removeEquivalenceClassPage(equivalenceClassIndex);

		}
		public void equivalenceClassReordered(IDatapool datapool,
				int equivalenceClassIndex) {
			// TODO Auto-generated method stub

		}
		public void recordAdded(IDatapool datapool, int EquivClassIndex,
				int newRecordIndex) {
			// TODO Auto-generated method stub

		}
		public void recordChanged(IDatapool datapool, int EquivClassIndex,
				int recordIndex) {
			// TODO Auto-generated method stub

		}
		public void recordMoved(IDatapool datapool, int EquivClassIndex,
				int sourceRecordIndex, int targetRecordIndex) {
			// TODO Auto-generated method stub

		}
		public void recordRemoved(IDatapool datapool, int EquivClassIndex,
				int recordIndex) {
			// TODO Auto-generated method stub

		}
		public void save(IDatapool datapool) {
			// TODO Auto-generated method stub

		}
		public void variableAdded(IDatapool datapool, int newVariableIndex) {
			// TODO Auto-generated method stub

		}
		public void variableChanged(IDatapool datapool, int variableIndex,
				String oldName) {
			// TODO Auto-generated method stub

		}
		public void variableChanged(IDatapool datapool, int variableIndex) {
			// TODO Auto-generated method stub

		}
		public void variableMoved(IDatapool datapool, int sourceVariableIndex,
				int targetVariableIndex) {
			// TODO Auto-generated method stub

		}
		public void variableRemoved(IDatapool datapool, int variableIndex) {
			// TODO Auto-generated method stub

		}
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		datapoolForm.getWidgetFactory().dispose();
		datapoolForm.dispose();
		
		Object page;
		for(Iterator it = equivalenceClassPages.iterator(); it.hasNext(); )
		{
		    page = it.next();
		    if(page != null)
		    ((DataTableForm)page).dispose();
		}
		
		equivalenceClassPages.clear();
		
		super.dispose();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	public void createPages() {
		IHyadesEditorPart hyadesEditorPart = getHyadesEditorPart();
		WidgetFactory widgetFactory = new WidgetFactory();
		
		datapoolForm = new DatapoolForm(this, widgetFactory);
		hyadesEditorPart.addPage(datapoolForm.createControl());
		hyadesEditorPart.setPageText(PAGE_OVERVIEW, TestUIPlugin.getString("W_OVERVIEW")); //$NON-NLS-1$		
		datapoolForm.updateTitle();
	
		IDatapool dp = getDatapool();		
		for(int i = 0; i < dp.getEquivalenceClassCount(); i++)
		{
			addEquivalenceClassPage(i);
		}
		
		if(dp.getEquivalenceClassCount() > 0)
		{
			// bugzilla 74864 difficult discovering data table -- show data table of default EC first. 
			int defaultIndex = dp.getDefaultEquivalenceClassIndex();
			defaultIndex = (defaultIndex == -1) ? 0 : defaultIndex;
			hyadesEditorPart.setActivePage(getEquivalenceClassPageIndex(defaultIndex));
		}
		
		dp.addDatapoolListener(this.datapoolListener);
	}
	
	public void addEquivalenceClassPage(int newECIndex)
	{
	    IDatapoolEquivalenceClass eqClass = (IDatapoolEquivalenceClass)getDatapool().getEquivalenceClass(newECIndex);
		IHyadesEditorPart hyadesEditorPart = getHyadesEditorPart();
		DataTableForm dataTableForm = new DataTableForm(this, new WidgetFactory(), eqClass);
		dataTableForm.initialize(eqClass);
		
		int index = hyadesEditorPart.addPage(dataTableForm.createControl());
		hyadesEditorPart.setPageText(index, eqClass.getName());	
		equivalenceClassPages.add(newECIndex, dataTableForm);
	}
	
	public void removeEquivalenceClassPage(int equivalenceClassIndex)
	{
		DataTableForm tableForm = (DataTableForm)equivalenceClassPages.remove(equivalenceClassIndex);
		if(tableForm != null)
		    tableForm.dispose();
		IHyadesEditorPart hyadesEditorPart = getHyadesEditorPart();	
		int pageIndex = getEquivalenceClassPageIndex(equivalenceClassIndex);
		hyadesEditorPart.removePage(pageIndex);
	}
	
	private void moveEquivalenceClassPage(int sourceECIndex, int targetECIndex)
	{
	    // Because IHyadesEditorPart can only append pages, but not insert a page in the middle
	    // have to remove pages and re-add them in new order.
	    int start = Math.min(sourceECIndex, targetECIndex);
	    for (int i = (getDatapool().getEquivalenceClassCount() - 1); i >= start; i--)
	        removeEquivalenceClassPage(i);
	    
	    for (int i = start; i < getDatapool().getEquivalenceClassCount(); i++)
	        addEquivalenceClassPage(i);
	}
	
	public int getEquivalenceClassPageIndex(int equivalenceClassIndex)
	{
		return (PAGE_OVERVIEW + equivalenceClassIndex + 1);
	}
	 
	private int getEquivalenceClassIndexFromPageIndex(int pageIndex)
	{
	    return (pageIndex - 1); 
	}

	/**
	 * Returns the datapool that is manipulated by this editor
	 * extension.
	 * @return DPLDatapool 
	 */
	public DPLDatapool getDatapool()
	{
		return (DPLDatapool)getHyadesEditorPart().getEditorObject();
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getSelection()
	 */
	public IStructuredSelection getSelection()
	{
		switch(getHyadesEditorPart().getActivePage())
		{
			case PAGE_OVERVIEW:
				return new StructuredSelection(getDatapool());
				
		}
		
		return StructuredSelection.EMPTY;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#pageActivated(int)
	 */
	public boolean pageActivated(int index)
	{
	    IWorkbenchPage activeWorkbenchPage = UIUtil.getActiveWorkbenchPage();
	    if(activeWorkbenchPage != null)
	    {
	        try {
	            activeWorkbenchPage.showView(IPageLayout.ID_PROP_SHEET, null, IWorkbenchPage.VIEW_VISIBLE);
	        }
	        catch(PartInitException e){}
	    }
	    
	    // base on which equivalence class page is activated,
	    // select the correponding equivalence class in overview page to display its attributes in Properties view.
	    if(index > PAGE_OVERVIEW)
	    {
		    int i = getEquivalenceClassIndexFromPageIndex(index);
		    IDatapoolEquivalenceClass ec = (IDatapoolEquivalenceClass)getDatapool().getEquivalenceClass(i);
		    if(ec != null)
		    {
		        ISelection selection = new StructuredSelection(ec);
		        datapoolForm.setSelection(selection);
		    }
	    }

		switch(index)
		{
			case PAGE_OVERVIEW:
				return datapoolForm.activated();		
		}
		
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#setSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void setSelection(IStructuredSelection structuredSelection)
	{
		if(structuredSelection.size() == 1)
		{
			Object object = structuredSelection.getFirstElement();
			if(object == getDatapool())
			{
				// don't do anything.
			}
		}
	}	

	/**
	 * @see org.eclipse.hyades.ui.util.IRefreshable#refreshContent(java.lang.Object)
	 */
	public void refreshContent(Object data)
	{
		datapoolForm.load();
		datapoolForm.updateTitle();
		
		DataTableForm dataTableForm;
		IDatapoolEquivalenceClass eqCls;
		IDatapool dp = getDatapool();
		for(int i = 0; i < dp.getEquivalenceClassCount(); i++)
		{
			dataTableForm = (DataTableForm)equivalenceClassPages.get(i);
			if(dataTableForm != null)
			{
				dataTableForm.load();
				dataTableForm.updateTitle();
				
				int pageIndex = getEquivalenceClassPageIndex(i);
				eqCls = (IDatapoolEquivalenceClass)dp.getEquivalenceClass(i);
				getHyadesEditorPart().setPageText(pageIndex, eqCls.getName());
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart#isReadOnly()
	 */
	public boolean isReadOnly() {
	 	return this.getHyadesEditorPart().isReadOnly();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart#getActionBars()
	 */
	public IActionBars getActionBars() {
		return this.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart#notifyEdit()
	 */
	public void notifyEdit() 
	{
	}
	
	public IEditorPart getEditorPart() {
		return this.getHyadesEditorPart().getEditorPart();
	}
}
