/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteEditorExtension.java,v 1.6 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.extension;

import org.eclipse.hyades.models.common.testprofile.TPFSUT;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.SUTsForm;
import org.eclipse.hyades.test.ui.internal.editor.form.TestCasesForm;
import org.eclipse.hyades.test.ui.internal.editor.form.TestComponentsForm;
import org.eclipse.hyades.test.ui.internal.editor.form.TestSuiteForm;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

/**
 * Hyades default test suite editor extension that is suitable for all the
 * test suite objects.
 * 
 * <p>This class is used whenever it is not possible neither to identify nor
 * to locate the appropriate extension editor.
 * 
 * @author marcelop
 * @since 0.0.1
 * @deprecated Use org.eclipse.hyades.test.ui.editor.extension.TestSuiteEditorExtension instead.
 */
public class TestSuiteEditorExtension 
extends BaseEditorExtension
{
	private static final int PAGE_OVERVIEW = 0;
	private static final int PAGE_TEST_CASES = 1;
	private static final int PAGE_TEST_COMPONENTS = 2;
	private static final int PAGE_SUTS = 3;
	
	public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.TestSuite"; //$NON-NLS-1$

	private TestSuiteForm testSuiteForm;
	private TestCasesForm testCasesForm;
	private TestComponentsForm testComponentsForm;
	private SUTsForm sutsForm;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		testSuiteForm.getWidgetFactory().dispose();
		testSuiteForm.dispose();
		testCasesForm.dispose();
		testComponentsForm.dispose();
		
		super.dispose();
	}

	/**
	 * Returns the test suite that is manipulated by this editor
	 * extension.
	 * @return TPFTestSuite 
	 */
	public TPFTestSuite getTestSuite()
	{
		return (TPFTestSuite)getHyadesEditorPart().getEditorObject();
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	public void createPages()
	{
//		IHyadesEditorPart hyadesEditorPart = getHyadesEditorPart();
//		WidgetFactory widgetFactory = new WidgetFactory();
		
//		testSuiteForm = new TestSuiteForm(this, widgetFactory);
//		testSuiteForm.setTestCasePageIndex(PAGE_TEST_CASES);
//		testSuiteForm.setTestComponentPageIndex(PAGE_TEST_COMPONENTS);
//		testSuiteForm.setSUTIndex(PAGE_SUTS);
//				
//		hyadesEditorPart.addPage(testSuiteForm.createControl());
//		hyadesEditorPart.setPageText(PAGE_OVERVIEW, TestUIPlugin.getString("W_OVERVIEW"));
//
//		testCasesForm = new TestCasesForm(this, widgetFactory);
//		hyadesEditorPart.addPage(testCasesForm.createControl());
//		hyadesEditorPart.setPageText(PAGE_TEST_CASES, TestUIPlugin.getString("W_TST_CASES"));
//		
//		testComponentsForm = new TestComponentsForm(this, widgetFactory);
//		hyadesEditorPart.addPage(testComponentsForm.createControl());
//		hyadesEditorPart.setPageText(PAGE_TEST_COMPONENTS, TestUIPlugin.getString("W_TST_COMPS"));
//
//		sutsForm = new SUTsForm(this, widgetFactory);
//		hyadesEditorPart.addPage(sutsForm.createControl());
//		hyadesEditorPart.setPageText(PAGE_SUTS, TestUIPlugin.getString("W_SUTS"));
		
		testSuiteForm.updateTitle();
	}

	/**
	 * @see org.eclipse.hyades.ui.util.IRefreshable#refreshContent(java.lang.Object)
	 */
	public void refreshContent(Object data)
	{
		testSuiteForm.load();
		testSuiteForm.updateTitle();
		
		testCasesForm.load();
		testComponentsForm.load();
		sutsForm.load();
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getSelection()
	 */
	public IStructuredSelection getSelection()
	{
		switch(getHyadesEditorPart().getActivePage())
		{
			case PAGE_OVERVIEW:
				return new StructuredSelection(getTestSuite());
				
			case PAGE_TEST_CASES:
				return (IStructuredSelection)testCasesForm.getSelection();

			case PAGE_TEST_COMPONENTS:
				return (IStructuredSelection)testComponentsForm.getSelection();

			case PAGE_SUTS:
				return (IStructuredSelection)sutsForm.getSelection();
		}
		
		return StructuredSelection.EMPTY;
	}
		
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#pageActivated(int)
	 */
	public boolean pageActivated(int index)
	{
		switch(index)
		{
			case PAGE_OVERVIEW:
				return testSuiteForm.activated();
				
			case PAGE_TEST_CASES:
				return testCasesForm.activated();

			case PAGE_TEST_COMPONENTS:
				return testComponentsForm.activated();

			case PAGE_SUTS:
				return sutsForm.activated();
		}
		
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#setSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void setSelection(IStructuredSelection structuredSelection)
	{
		if(structuredSelection.size() == 1)
		{
			Object object = structuredSelection.getFirstElement();
			if(object == getTestSuite())
			{
				// don't do anything.
			}
			else if(object instanceof TPFTestCase)
			{
				getHyadesEditorPart().setActivePage(PAGE_TEST_CASES);
				testCasesForm.selectReveal(structuredSelection);
			}
			else if(object instanceof TPFTestComponent)
			{
				getHyadesEditorPart().setActivePage(PAGE_TEST_COMPONENTS);
				testComponentsForm.selectReveal(structuredSelection);
			}
			else if(object instanceof TPFSUT)
			{
				getHyadesEditorPart().setActivePage(PAGE_SUTS);
				sutsForm.selectReveal(structuredSelection);
			}
		}
	}
}