/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ArtifactForm.java,v 1.3 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.swt.widgets.Composite;

/**
 * This class is the overview page of the Artifact resource editor.
 * 
 * @author bjiang
 * @since  3.0
 */
public class ArtifactForm extends ConfigurableObjectOverviewForm
{
	private int assetsPageIndex;	
	private NamedElementsSection assetsSection;
	
	/**
	 * Constructor for ArtifactForm
	 * @param artifactEditorExtension
	 * @param widgetFactory
	 */
	public ArtifactForm(ConfigurableObjectEditorExtension artifactEditorExtension, WidgetFactory widgetFactory)
	{
		super(artifactEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_ARTIFACT")); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		if(assetsSection != null)
		{
		    assetsSection.dispose();
		    assetsSection = null;
		}

		super.dispose();
	}
	
	/**
	 * Sets the index of the Test Assets tab that is presented when the "more" button
	 * of the Test Assets section is pressed. 
	 * @param index
	 */
	public void setTestAssetsPageIndex(int index)
	{
	    assetsPageIndex = index;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		super.createEditorFormContents(parent);	
		
		assetsSection = new NamedElementsSection(getBaseEditorExtension(), assetsPageIndex);
		registerSection(assetsSection);
		assetsSection.createControl(getRightColumnContainer(), factory, TestUIPlugin.getString("W_TEST_ASSETS"), TestUIPlugin.getString("EDT_ART_AST_DSC"));
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
	    super.load();
	    assetsSection.initialize(getDataObject(), Common_ConfigurationPackage.eINSTANCE.getCFGArtifact_DeployableInstances(), null);
	}
}
