/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionForm.java,v 1.9 2005/03/02 23:41:34 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ExecutionEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class ExecutionForm 
extends EditorForm
{	
	private NamedElementSection namedElementSection;
	private DetailSection detailSection;
	
	/**
	 * Constructor for ExecutionForm
	 * @param executionEditorExtension
	 * @param widgetFactory
	 */
	public ExecutionForm(ExecutionEditorExtension executionEditorExtension, WidgetFactory widgetFactory)
	{
		super(executionEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_EXECUTION")); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		namedElementSection.dispose();
		namedElementSection = null;

		detailSection.dispose();
		
		super.dispose();
	}

	/**
	 * Returns the execution manipulated by this form.
	 * @return TPFExecutionResult
	 */
	public TPFExecutionResult getExecution()
	{
		return ((ExecutionEditorExtension)getBaseEditorExtension()).getExecution();		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createControl()
	 */
	public Control createControl()
	{
		Control control = super.createControl();
		return control;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		WorkbenchHelp.setHelp(parent, TestUIPlugin.getID() + ContextIds.EXEC_EDIT_OVERVIEW);
		
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);

		Control control = createGenericInformation(leftColumn);
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));

		detailSection = new DetailSection(this);
		detailSection.add(TPFExecutionResult.class, new ExecutionResultDetailPage());
		detailSection.setHeaderText(TestUIPlugin.getString("W_SUMMARY")); //$NON-NLS-1$
		registerSection(detailSection);
		control = detailSection.createControl(rightColumn, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);
	}
	
	/**
	 * Creates the generic information form section.
	 * @return FormSection
	 */
	protected Control createGenericInformation(Composite parent)
	{
		namedElementSection = new NamedElementSection(this)
		{
			private StyledText fileText;
			
			protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory)
			{
				Composite detailComposite = getWidgetFactory().createComposite(parent);
				GridLayout gridLayout = new GridLayout(2, false);
				gridLayout.marginHeight = 0;
				gridLayout.marginWidth = 0;
				detailComposite.setLayout(gridLayout);
				detailComposite.setLayoutData(GridDataUtil.createHorizontalFill());

				getWidgetFactory().createLabel(detailComposite, TestUIPlugin.getString("L_FILE")); //$NON-NLS-1$
				fileText = getWidgetFactory().createStyledText(detailComposite, SWT.FULL_SELECTION | SWT.SINGLE);
				fileText.setEnabled(false);
				fileText.setLayoutData(GridDataUtil.createHorizontalFill());
				WorkbenchHelp.setHelp(fileText, TestUIPlugin.getID() + ContextIds.DEPL_TEXT_FORM);		
			}
			
			public void setInput(Object object)
			{
				super.setInput(object);
				fileText.setText(EMFUtil.getFilePath(getExecution()));						
			}
		};
		registerSection(namedElementSection);		
		namedElementSection.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO")); //$NON-NLS-1$
		namedElementSection.setDescription(TestUIPlugin.getString("EDT_GENERAL_DSC")); //$NON-NLS-1$
		return namedElementSection.createControl(parent, getWidgetFactory());
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		namedElementSection.setInput(getExecution());
		detailSection.setInput(getExecution());
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#updateTitle()
	 */
	public void updateTitle()
	{
		String title = ((IWorkbenchAdapter)((IAdaptable)getExecution()).getAdapter(IWorkbenchAdapter.class)).getLabel(getExecution());
		if(title != null)
			getBaseEditorExtension().getHyadesEditorPart().setTitle(title);
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		return true;
	}
}
