/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ListPart.java,v 1.3 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/**
 * @author bjiang
 * @since  3.3
 */
public class ListPart extends StructuredViewerPart
{

    /**
     * @param buttonLabels
     */
    public ListPart(String[] buttonLabels)
    {
        super(buttonLabels);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart#createStructuredViewer(org.eclipse.swt.widgets.Composite, int, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
     */
    protected StructuredViewer createStructuredViewer(Composite parent,
            int style, FormWidgetFactory factory)
    {
        style |= SWT.H_SCROLL | SWT.V_SCROLL;
		if (factory == null)
		{
			style |= SWT.BORDER;
		}
		else
		{
			style |= FormWidgetFactory.BORDER_STYLE;
		}
		ListViewer listViewer = new ListViewer(parent, style);
        return listViewer;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.editor.form.base.SharedPartWithButtons#buttonSelected(org.eclipse.swt.widgets.Button, int)
     */
    protected void buttonSelected(Button button, int index)
    {
    }

    public ListViewer getListViewer()
    {
        return (ListViewer)getViewer();
    }
}
