/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SharedPart.java,v 1.4 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/**
 * @author marcelop
 * @since 0.2.0
 */
public abstract class SharedPart
{
	private boolean enabled = true;

	public void setEnabled(boolean enabled)
	{
		if (enabled != this.enabled)
		{
			this.enabled = enabled;
			updateEnabledState();
		}
	}

	public abstract void createControl(Composite parent, int style, int span, FormWidgetFactory factory);

	public boolean isEnabled()
	{
		return enabled;
	}

	protected void updateEnabledState()
	{
	}

	protected Composite createComposite(Composite parent, FormWidgetFactory factory)
	{
		if (factory == null)
			return new Composite(parent, SWT.NULL);
		else
			return factory.createComposite(parent);
	}
	protected Label createEmptySpace(Composite parent, int span, FormWidgetFactory factory)
	{
		Label label;
		if (factory != null)
		{
			label = factory.createLabel(parent, null);
		}
		else
		{
			label = new Label(parent, SWT.NULL);
		}
		GridData gd = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = span;
		gd.widthHint = 0;
		gd.heightHint = 0;
		label.setLayoutData(gd);
		return label;
	}
}
