/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ListSection.java,v 1.3 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ListPart;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/**
 * @author bjiang
 */
public class ListSection extends StructuredViewerSection
{
    protected class PartAdapter
	extends ListPart
	{
		public PartAdapter(String[] buttonLabels)
		{
			super(buttonLabels);
		}
		public void selectionChanged(IStructuredSelection selection)
		{
			ListSection.this.selectionChanged(selection);
		}
		public void handleDoubleClick(IStructuredSelection selection)
		{
			ListSection.this.handleDoubleClick(selection);
		}
		public void buttonSelected(Button button, int index)
		{
			ListSection.this.buttonSelected(index);
			if(isHandlingDefaultButton())
				button.getShell().setDefaultButton(null);
		}
	}

    /**
     * @param editorForm
     * @param buttonLabels
     */
    public ListSection(EditorForm editorForm, String[] buttonLabels)
    {
        super(editorForm, buttonLabels);
        // TODO Auto-generated constructor stub
    }

    /**
     * @param editorForm
     */
    public ListSection(EditorForm editorForm)
    {
        super(editorForm);
        // TODO Auto-generated constructor stub
    }
    
    public ListViewer getListViewer()
    {
        return (ListViewer)this.getViewerPart().getViewer();
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.editor.form.util.StructuredViewerSection#createViewerPart(java.lang.String[])
     */
    protected StructuredViewerPart createViewerPart(String[] buttonLabels)
    {
        return new PartAdapter(buttonLabels);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
     */
    public Composite createClient(Composite parent, FormWidgetFactory factory)
    {
        setFormWidgetFactory(factory);
		Composite container = createClientContainer(parent, 2, getFormWidgetFactory());
		createViewerPartControl(container, SWT.MULTI, 2, getFormWidgetFactory());
		
		getViewerPart().getControl().setFocus();

		adjustClient(parent);

		getFormWidgetFactory().paintBordersFor(container);
		return container;
    }
    
    /**
	 * This method helps subclasses to extend the create client method.
	 * @param parent
	 */
	protected void adjustClient(Composite parent)
	{		
	}

}
