/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestUIResourceFactoryImpl.java,v 1.6 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

import org.eclipse.hyades.models.common.util.ICommonConstants;

/**
 * @author marcelop
 * @since 0.2.0 
 * @deprecated use {@link org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl FacadeResourceFactoryImpl} instead.
 */
public class TestUIResourceFactoryImpl
extends XMIResourceFactoryImpl
{
	/**
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl#createResource(org.eclipse.emf.common.util.URI)
	 */
	public Resource createResource(URI uri)
	{
		XMIResource xmiResource =  (XMIResource)super.createResource(uri);
		xmiResource.setEncoding(ICommonConstants.DEFAULT_ENCODING);
		xmiResource.setUseZip(true);
		
		return xmiResource;
	}
}
