/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionContentProvider.java,v 1.8 2005/03/02 23:41:34 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * @author marcelop
 * @since 0.3.0
 * @deprecated
 */
public class ExecutionContentProvider 
implements ITreeContentProvider, IDisposable
{
	public static class ElementDescription
	{
		private String fileExtension;
		private List eClassifiers;
		
		public ElementDescription(String fileExtension)
		{
			this.fileExtension = fileExtension;
		}
		
		public String getFileExtension()
		{
			return fileExtension;
		}

		public List getEClassifiers()
		{
			if(eClassifiers == null)
				eClassifiers = new UniqueEList();
			return eClassifiers;
		}
	}
	
	private ResourceSet resourceSet;
	
	private Map elementDescriptionByFileExtension;
	private boolean showEMFResource;
	private boolean showEnabledChildren=true;

	/**
	 * Constructor for EMFContentProvider
	 */
	public ExecutionContentProvider(ResourceSet resourceSet)
	{
		this.resourceSet = resourceSet;
		
		elementDescriptionByFileExtension = new HashMap();
		showEMFResource = false;
	}

	/**
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose()
	{
		elementDescriptionByFileExtension.clear();
	}
	
	public void addElementDescription(ElementDescription elementDescription)
	{
		elementDescriptionByFileExtension.put(elementDescription.getFileExtension(), elementDescription);
	}

	/**
	 * @return
	 */
	public boolean isShowEMFResource()
	{
		return showEMFResource;
	}

	/**
	 * @param showEMFResource
	 */
	public void setShowEMFResource(boolean showEMFResource)
	{
		this.showEMFResource = showEMFResource;
	}

	/**
	 * @return
	 */
	public boolean isShowEnabledChildren()
	{
		return showEnabledChildren;
	}

	/**
	 * @param showEnabledChildren
	 */
	public void setShowEnabledChildren(boolean showEnabledChildren)
	{
		this.showEnabledChildren = showEnabledChildren;
	}

	/**
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput)
	{
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element)
	{
		if(element instanceof IResource)
			return ((IResource)element).getParent();
			
		else if(element instanceof Resource)
		{
			return EMFUtil.getParent((Resource)element);
		}
		
		else if((element instanceof TPFExecutionResult) && (((TPFExecutionResult)element).eContainer() == null))
			return ((TPFExecutionResult)element).getTest();
			
		else if(element instanceof EObject)
		{			
			EObject eObject = (EObject)element;
			if(eObject.eContainer() != null)
				return eObject.eContainer();
				
			if(isShowEMFResource())
				return eObject.eResource();
			return EMFUtil.getParent(eObject.eResource());
		}
		return null;
	}

	/**
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement)
	{
		List children = new ArrayList();
		if(inputElement instanceof IWorkspaceRoot)
			children.addAll(Arrays.asList(((IWorkspaceRoot)inputElement).getProjects()));
		children.addAll(NavigatorExtensionUtil.getAllChildren(inputElement, ExecutionNavigator.ID));
		return children.toArray();
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element)
	{
		if (NavigatorExtensionUtil.hasChildren(element, ExecutionNavigator.ID))
			return true;
		
		if(element instanceof IContainer)
		{
			IContainer container = (IContainer)element;
			if(!container.exists())
				return false;

			IResource[] resources = null;
			try
			{
				resources = container.members();
			}
			catch (CoreException e)
			{
				TestUIPlugin.logError(e);
				return false;
			}
			
			for(int i = 0, maxi = resources.length; i < maxi; i++)
			{
				if(resources[i].getType() != IResource.FILE)
					return true;
				
				ElementDescription elementDescription = (ElementDescription)elementDescriptionByFileExtension.get(resources[i].getFileExtension());
				if(elementDescription != null)
				{
					EObject[] eObjects = EMFUtil.load(resourceSet, (IFile)resources[i]);
					for (Iterator iter = elementDescription.getEClassifiers().iterator(); iter.hasNext();)
					{
						if(EcoreUtil.getObjectByType(Arrays.asList(eObjects), (EClassifier)iter.next()) != null)
							return true;
					}
				}
			}
		}
		
		else if (element instanceof Resource)
			return !((Resource)element).getContents().isEmpty();
			
		else if(element instanceof TPFTest)
		{
			return ExecutionUtil.findExecutionResults((TPFTest)element).size() > 0;
		}
		
		return false;
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement)
	{
		List children = new ArrayList();
		if(parentElement instanceof IContainer)
		{
			IResource[] resources = null;
			try
			{
				resources = ((IContainer)parentElement).members();
			}
			catch (CoreException e)
			{
				TestUIPlugin.logError(e);
				children.addAll(NavigatorExtensionUtil.getAllChildren(parentElement, ExecutionNavigator.ID));
				return children.toArray();
			}
			
			for(int i = 0, maxi = resources.length; i < maxi; i++)
			{
				if(resources[i].getType() != IResource.FILE)
				{
					children.add(resources[i]);
				}
				else
				{
					ElementDescription elementDescription = (ElementDescription)elementDescriptionByFileExtension.get(resources[i].getFileExtension());
					if(elementDescription != null)
					{
						EObject[] eObjects = EMFUtil.load(resourceSet, (IFile)resources[i]);
						for (Iterator iter = elementDescription.getEClassifiers().iterator(); iter.hasNext();)
						{
							Collection validObjects = EcoreUtil.getObjectsByType(Arrays.asList(eObjects), (EClassifier)iter.next());
							if(isShowEMFResource())
							{
								for (Iterator iter2 = validObjects.iterator(); iter2.hasNext();)
									children.add(((EObject)iter2.next()).eResource());
							}
							else
							{
								children.addAll(validObjects);
							}
						}
					}
				}
			}
		}
		
		else if(parentElement instanceof Resource)
			children.addAll(((Resource)parentElement).getContents());
		
		else if(parentElement instanceof TPFTest)
		{
				children.addAll(ExecutionUtil.findExecutionResults((TPFTest)parentElement));				
		}
		
		children.addAll(NavigatorExtensionUtil.getAllChildren(parentElement, ExecutionNavigator.ID));
		return children.toArray();
	}
}
