/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITypeProviderFactory.java,v 1.3 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;

/**
 * @author jcanches
 */
public interface ITypeProviderFactory {
	/** Returns the associated provider for the given type of element found in the HTN
	 * 
	 * @param type the type of element
	 * @return a provider for the given type <code>type</code> or <code>null</code> if the type does not exist (or problem has been encountered)
	 */
	IHyadesTestNavigatorProvider getProvider(String type);
}